<?php
header('Content-Type: application/json');
require '../db_connect.php';

// হেডার থেকে API Key দিয়ে অথেন্টিকেশন
$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';
if (empty($api_key)) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'API Key is missing.']);
    exit();
}

$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting = $stmt_user->fetch(PDO::FETCH_ASSOC);

if (!$setting) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Invalid API Key.']);
    exit();
}
$user_id = $setting['user_id'];

// অ্যাপ থেকে পাঠানো ডেটা
$gateway_id = $_POST['gateway_id'] ?? null;
$display_name = $_POST['display_name'] ?? '';
$account_number = $_POST['account_number'] ?? '';

if (empty($gateway_id) || empty($display_name)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Gateway ID and display name are required.']);
    exit();
}

try {
    // শুধুমাত্র নিজের গেটওয়ে আপডেট করার জন্য user_id দিয়েও শর্ত দেওয়া হয়েছে
    $sql = "UPDATE gateways SET display_name = :display_name, account_number = :account_number 
            WHERE id = :gateway_id AND user_id = :user_id";
    $stmt = $pdo->prepare($sql);
    
    if ($stmt->execute([
        'display_name' => $display_name, 
        'account_number' => $account_number, 
        'gateway_id' => $gateway_id, 
        'user_id' => $user_id
    ])) {
        echo json_encode(['success' => true, 'message' => 'Gateway updated successfully.']);
    } else {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Failed to update gateway.']);
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error.', 'error' => $e->getMessage()]);
}
?>