<?php
header('Content-Type: application/json');
require '../db_connect.php';

$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';
if (empty($api_key)) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'API Key is missing.']);
    exit();
}

$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting = $stmt_user->fetch(PDO::FETCH_ASSOC);

if (!$setting) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Invalid API Key.']);
    exit();
}
$user_id = $setting['user_id'];

// অ্যাপ থেকে পাঠানো ডেটা
$gateway_id = $_POST['gateway_id'] ?? null;
$display_name = $_POST['display_name'] ?? '';
$min_amount = $_POST['min_amount'] ?: null;
$max_amount = $_POST['max_amount'] ?: null;
$fixed_charge = $_POST['fixed_charge'] ?: null;
$percentage_charge = $_POST['percentage_charge'] ?: null;

// ★★★ সমাধান: টেস্ট মোডের মান (value) সঠিকভাবে চেক করা হচ্ছে ★★★
// এখন এটি '1' পেলেই শুধু 1 সেভ করবে, অন্যথায় 0 সেভ করবে।
$test_mode = (isset($_POST['test_mode']) && $_POST['test_mode'] === '1') ? 1 : 0;

$app_key = $_POST['app_key'] ?? '';
$app_secret = $_POST['app_secret'] ?? '';
$username = $_POST['username'] ?? '';
$password = $_POST['password'] ?? '';

if (empty($gateway_id) || empty($display_name)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Gateway ID and Display Name are required.']);
    exit();
}

try {
    $sql = "UPDATE gateways SET 
                display_name = :d_name, min_amount = :min_a, max_amount = :max_a, 
                fixed_charge = :f_charge, percentage_charge = :p_charge, 
                app_key = :app_k, app_secret = :app_s, username = :uname, 
                password = :pass, test_mode = :test_mode 
            WHERE id = :id AND user_id = :uid";

    $params = [
        'd_name' => $display_name, 'min_a' => $min_amount, 'max_a' => $max_amount, 
        'f_charge' => $fixed_charge, 'p_charge' => $percentage_charge,
        'app_k' => $app_key, 'app_s' => $app_secret, 'uname' => $username, 
        'pass' => $password, 'test_mode' => $test_mode, 'id' => $gateway_id, 'uid' => $user_id
    ];
    
    $stmt = $pdo->prepare($sql);
    if ($stmt->execute($params)) {
        echo json_encode(['success' => true, 'message' => 'Merchant gateway updated successfully.']);
    } else {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Failed to update merchant gateway.']);
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error.', 'error' => $e->getMessage()]);
}
?>