<?php
header('Content-Type: application/json');
require '../db_connect.php';

$headers = getallheaders();
$auth_header = $headers['Authorization'] ?? '';
if (!preg_match('/Bearer\s(\S+)/', $auth_header, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'API key is missing or invalid.']);
    exit();
}
$api_key = $matches[1];

$stmt_user = $pdo->prepare("SELECT user_id, base_url FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting = $stmt_user->fetch(PDO::FETCH_ASSOC);

if (!$setting) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'Invalid API key.']);
    exit();
}
$user_id = $setting['user_id'];
$base_url = $setting['base_url'] ?? ''; // ★★★ পরিবর্তন: ডাটাবেস থেকে বেস ইউআরএল আনা হয়েছে ★★★

$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

$amount = $data['amount'] ?? 0;
if ($amount <= 0) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Amount must be greater than zero.']);
    exit();
}

try {
    $unique_id = sha1(uniqid(rand(), true) . microtime()); 

    $sql = "INSERT INTO transactions (user_id, unique_id, amount, customer_name, customer_email, success_url, cancel_url, meta_data) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        $user_id,
        $unique_id,
        $amount,
        $data['customer_name'] ?? null,
        $data['customer_email'] ?? null,
        $data['success_url'] ?? null,
        $data['cancel_url'] ?? null,
        $data['meta_data'] ?? null
    ]);

    // ★★★ পরিবর্তন শুরু: এখন আর $_SERVER ব্যবহার না করে, সংরক্ষিত base_url দিয়ে লিঙ্ক তৈরি করা হচ্ছে ★★★
    if (empty($base_url)) {
        throw new Exception("Base URL is not configured in API settings.");
    }
    // base_url টি '.../api' দিয়ে শেষ হয়, তাই আমরা '/api' অংশটি বাদ দিয়ে checkout.php যোগ করবো
    $project_root_url = str_replace('/api', '', $base_url);
    $payment_url = "{$project_root_url}/checkout.php?trx_id={$unique_id}";
    // ★★★ পরিবর্তন শেষ ★★★

    http_response_code(201);
    echo json_encode(['status' => 'success', 'payment_url' => $payment_url]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Failed to create transaction.', 'error_details' => $e->getMessage()]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>