<?php
require 'auth_check.php';
require 'db_connect.php';

$user_id = $_SESSION['user_id'];

// `settings` টেবিল থেকে API Key এবং base_url আনা হচ্ছে
$stmt = $pdo->prepare("SELECT api_key, base_url FROM settings WHERE user_id = ?");
$stmt->execute([$user_id]);
$setting = $stmt->fetch(PDO::FETCH_ASSOC);

$api_key = $setting['api_key'] ?? '';
$base_url = $setting['base_url'] ?? '';

// === স্বয়ংক্রিয়ভাবে Base URL তৈরি এবং সংরক্ষণ ===
if (empty($base_url)) {
    // যদি ডেটাবেসে base_url সেভ করা না থাকে, তাহলে এটি তৈরি করে সেভ করা হবে
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https" : "http";
    $host = $_SERVER['HTTP_HOST'];
    $directory = rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
    
    // চূড়ান্ত API URL
    $generated_url = "{$protocol}://{$host}{$directory}/api";

    // ডেটাবেসে এই URL টি সেভ করা হচ্ছে
    // ON DUPLICATE KEY UPDATE ব্যবহার করা হয়েছে যাতে settings row না থাকলে নতুন row তৈরি হয়
    $sql = "INSERT INTO settings (user_id, base_url) VALUES (?, ?) ON DUPLICATE KEY UPDATE base_url = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$user_id, $generated_url, $generated_url]);
    
    // পেজটি রিলোড করা হচ্ছে যাতে নতুন URL টি দেখানো যায়
    header("Location: api_settings.php");
    exit();
}

// API Key জেনারেট করার জন্য POST রিকোয়েস্ট হ্যান্ডেল করা
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'generate_key') {
    $new_api_key = bin2hex(random_bytes(32));
    
    // ON DUPLICATE KEY UPDATE ব্যবহার করে 안전하게 আপডেট করা
    $sql = "INSERT INTO settings (user_id, api_key) VALUES (?, ?) ON DUPLICATE KEY UPDATE api_key = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$user_id, $new_api_key, $new_api_key]);
    
    header("Location: api_settings.php");
    exit();
}

// ডেটাবেস থেকে পাওয়া base_url ব্যবহার করে সম্পূর্ণ এন্ডপয়েন্ট তৈরি করা
$endpoint_initiate = "{$base_url}/initiate_payment.php";
$endpoint_verify = "{$base_url}/verify_payment.php";

include 'templates/header.php';
include 'templates/sidebar.php';
?>

<div class="page-container">
    <!-- কার্ড ১: API Access Credentials -->
    <div class="content-card api-card">
        <div class="card-header">
            <h3>API Access Credentials</h3>
            <p>Manage your API keys and endpoints for integration</p>
        </div>
        <div class="card-body">
            <div class="form-group">
                <label for="api_key">API Key</label>
                <div class="input-with-actions">
                    <input type="password" id="api_key" value="<?php echo htmlspecialchars($api_key); ?>" readonly>
                    <div class="actions">
                        <button class="icon-btn" id="toggle-key-visibility"><i class="far fa-eye"></i></button>
                        <form action="api_settings.php" method="POST" style="display: inline;">
                            <input type="hidden" name="action" value="generate_key">
                            <button type="submit" class="icon-btn" title="Generate New Key"><i class="fas fa-sync-alt"></i></button>
                        </form>
                        <button class="icon-btn copy-btn" data-copy-target="api_key"><i class="far fa-copy"></i></button>
                    </div>
                </div>
                <small>Your secret API key for authentication</small>
            </div>
        </div>
    </div>

    <!-- কার্ড ২: API Endpoints -->
    <div class="content-card api-card">
        <div class="card-header">
            <h3>API Endpoints</h3>
            <p>Your unique API endpoints for integration</p>
        </div>
        <div class="card-body">
            <div class="form-group">
                <label for="base_url">Base URL</label>
                <div class="input-with-actions">
                    <input type="text" id="base_url" value="<?php echo htmlspecialchars($base_url); ?>" readonly>
                    <button class="icon-btn copy-btn" data-copy-target="base_url"><i class="far fa-copy"></i></button>
                </div>
                <small>This is your root API endpoint. It is set automatically and cannot be changed.</small>
            </div>
            
            <div class="form-group">
                <label for="initiate_url">Payment Initiation Endpoint</label>
                <div class="input-with-actions">
                    <input type="text" id="initiate_url" value="<?php echo htmlspecialchars($endpoint_initiate); ?>" readonly>
                    <button class="icon-btn copy-btn" data-copy-target="initiate_url"><i class="far fa-copy"></i></button>
                </div>
                <small>Send a POST request to create a payment session.</small>
            </div>

            <div class="form-group">
                <label for="verify_url">Verify Payment Endpoint</label>
                <div class="input-with-actions">
                    <input type="text" id="verify_url" value="<?php echo htmlspecialchars($endpoint_verify); ?>" readonly>
                    <button class="icon-btn copy-btn" data-copy-target="verify_url"><i class="far fa-copy"></i></button>
                </div>
                <small>Send a POST request to verify a payment's status.</small>
            </div>
        </div>
    </div>

    <!-- কার্ড ৩: Documentation -->
    <div class="content-card api-card documentation-card">
        <div class="card-header">
            <h3><i class="far fa-file-alt"></i> Documentation</h3>
            <p>Access our comprehensive API documentation for integration details</p>
        </div>
        <div class="card-body">
            <a href="documentation.php" class="btn btn-primary"><i class="far fa-bookmark"></i> View Developer Docs</a>
        </div>
    </div>
</div>

</div> <!-- .main-content বন্ধ করার ট্যাগ -->

<script src="js/main.js?v=<?php echo filemtime('js/main.js'); ?>"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('.copy-btn').forEach(button => {
        button.addEventListener('click', function() {
            const targetId = this.dataset.copyTarget;
            const input = document.getElementById(targetId);
            
            const isPassword = input.type === 'password';
            if (isPassword) input.type = 'text';
            
            input.select();
            document.execCommand('copy');
            
            if (isPassword) input.type = 'password';
            
            const originalIcon = this.innerHTML;
            this.innerHTML = '<i class="fas fa-check"></i>';
            setTimeout(() => { this.innerHTML = originalIcon; }, 1500);
        });
    });

    const toggleBtn = document.getElementById('toggle-key-visibility');
    if (toggleBtn) {
        toggleBtn.addEventListener('click', function() {
            const apiKeyInput = document.getElementById('api_key');
            const icon = this.querySelector('i');
            if (apiKeyInput.type === 'password') {
                apiKeyInput.type = 'text';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            } else {
                apiKeyInput.type = 'password';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            }
        });
    }
});
</script>
</body>
</html>