<?php
require 'auth_check.php';
require 'db_connect.php';

$user_id = $_SESSION['user_id'];
$success_message = '';
$upload_dir = "uploads/logos/{$user_id}/";

// ডেটাবেস থেকে বর্তমান লোগো গুলো আনা হচ্ছে
$stmt_fetch = $pdo->prepare("SELECT * FROM brand_logos WHERE user_id = ?");
$stmt_fetch->execute([$user_id]);
$current_logos = $stmt_fetch->fetch(PDO::FETCH_ASSOC);

// ছবি আপলোড এবং ডিলিট হ্যান্ডেল করার জন্য ফাংশন
function handle_upload($file_key, $upload_dir, $current_file_path) {
    if (!empty($_POST['remove_' . $file_key]) && $_POST['remove_' . $file_key] === '1') {
        if ($current_file_path && file_exists($current_file_path)) {
            unlink($current_file_path);
        }
        return null;
    }

    if (isset($_FILES[$file_key]) && $_FILES[$file_key]['error'] === UPLOAD_ERR_OK) {
        $file = $_FILES[$file_key];
        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0777, true);
        }
        if ($current_file_path && file_exists($current_file_path)) {
            unlink($current_file_path);
        }
        $file_ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
        $new_filename = uniqid($file_key . '_', true) . '.' . $file_ext;
        $destination = $upload_dir . $new_filename;
        if (move_uploaded_file($file['tmp_name'], $destination)) {
            return $destination;
        }
    }
    return $current_file_path;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $primary_logo_path = handle_upload('primary_logo', $upload_dir, $current_logos['primary_logo'] ?? null);
    $round_logo_path = handle_upload('round_logo', $upload_dir, $current_logos['round_logo'] ?? null);
    $favicon_path = handle_upload('favicon', $upload_dir, $current_logos['favicon'] ?? null);

    $sql = "INSERT INTO brand_logos (user_id, primary_logo, round_logo, favicon) VALUES (:user_id, :p_logo, :r_logo, :fav)
            ON DUPLICATE KEY UPDATE primary_logo = :p_logo, round_logo = :r_logo, favicon = :fav";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([':user_id' => $user_id, ':p_logo' => $primary_logo_path, ':r_logo' => $round_logo_path, ':fav' => $favicon_path]);

    header("Location: brand_icon.php?success=1");
    exit();
}

if(isset($_GET['success'])) {
    $success_message = "Logos have been updated successfully!";
}

include 'templates/header.php';
include 'templates/sidebar.php';
?>

<div class="page-container">
    <div class="page-header">
        <div><p class="breadcrumbs">Brand Settings > Brand Icon & Favicon</p><h1 class="page-title">Logo & Favicon</h1></div>
    </div>

    <div class="content-card">
        <form action="brand_icon.php" method="POST" enctype="multipart/form-data">
            <div class="settings-section" style="border-top: none; padding-top: 10px;">
                <h3>Logo & Favicon</h3><p>Configure the logos used throughout your application</p>
                <div class="logo-uploader-grid">
                    <?php
                    function render_uploader($name, $label, $tooltip, $current_path, $is_round = false, $size_text) {
                        $has_image = !empty($current_path);
                        $uploader_class = 'image-uploader' . ($is_round ? ' uploader-round' : '') . ($has_image ? ' has-preview' : '');
                        echo '<div class="form-group">';
                        echo '  <label class="label-with-tooltip">'.$label.($tooltip ? ' <i class="fas fa-question-circle"></i>' : '').'</label>';
                        echo '  <div class="'.$uploader_class.'" id="'.$name.'_uploader">';
                        echo '      <input type="file" name="'.$name.'" accept="image/*">';
                        echo '      <input type="hidden" name="remove_'.$name.'" value="">';
                        echo '      <div class="uploader-content">';
                        if ($has_image) {
                            echo '<div class="preview-container">';
                            echo '  <img src="'.htmlspecialchars($current_path).'?t='.time().'" alt="Preview" class="image-preview">';
                            echo '  <button type="button" class="remove-image-btn">&times;</button>';
                            echo '</div>';
                        } else {
                            echo '<div class="uploader-text">Drag & Drop your files or <span class="browse-link">Browse</span></div>';
                        }
                        echo '      </div>';
                        echo '  </div>';
                        echo '  <small>'.$size_text.'</small>';
                        echo '</div>';
                    }

                    render_uploader('primary_logo', 'Primary Logo', false, $current_logos['primary_logo'] ?? null, false, 'Main logo used in header and emails (48x48 recommended)');
                    render_uploader('round_logo', 'Round Logo', true, $current_logos['round_logo'] ?? null, true, 'Used for avatars and round logo displays (32x32 recommended)');
                    render_uploader('favicon', 'Favicon', true, $current_logos['favicon'] ?? null, true, 'Browser tab icon (32x32 recommended)');
                    ?>
                </div>
            </div>
            <div class="settings-actions"><button type="submit" class="btn btn-primary">Save changes</button></div>
        </form>
    </div>
</div>

</div> <!-- .main-content -->
<div id="toast-notification"></div>
<script src="js/main.js?v=<?php echo filemtime('js/main.js'); ?>"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    <?php if (!empty($success_message)): ?>
        showToast('<?php echo $success_message; ?>', true);
    <?php endif; ?>

    document.querySelectorAll('.image-uploader').forEach(uploader => {
        const fileInput = uploader.querySelector('input[type="file"]');
        const removeInput = uploader.querySelector('input[type="hidden"]');
        const content = uploader.querySelector('.uploader-content');
        const originalContentHTML = '<div class="uploader-text">Drag & Drop your files or <span class="browse-link">Browse</span></div>';

        const updatePreview = (file) => {
            if (!file) return;
            const reader = new FileReader();
            reader.onload = (e) => {
                content.innerHTML = `
                    <div class="preview-container">
                        <img src="${e.target.result}" alt="Preview" class="image-preview">
                        <button type="button" class="remove-image-btn">&times;</button>
                    </div>`;
                uploader.classList.add('has-preview');
                removeInput.value = "";
            };
            reader.readAsDataURL(file);
        };

        const removePreview = () => {
            fileInput.value = '';
            removeInput.value = "1";
            content.innerHTML = originalContentHTML;
            uploader.classList.remove('has-preview');
        };

        // ★★★ মূল সমাধান এখানে ★★★
        uploader.addEventListener('click', (e) => {
            // প্রথমে চেক করা হচ্ছে যে রিমুভ বাটনে ক্লিক করা হয়েছে কিনা
            if (e.target.classList.contains('remove-image-btn')) {
                e.stopPropagation(); // ইভেন্টটিকে অন্য কোথাও যেতে বাধা দেওয়া হচ্ছে
                removePreview();
                return; // ফাংশন থেকে বের হয়ে যাওয়া হচ্ছে
            }
            
            // যদি রিমুভ বাটন না হয়, তবে আপলোডারের যেকোনো জায়গায় ক্লিক করলে ফাইল ইনপুট ওপেন হবে
            fileInput.click();
        });

        fileInput.addEventListener('change', () => updatePreview(fileInput.files[0]));

        uploader.addEventListener('dragover', (e) => { e.preventDefault(); uploader.classList.add('drag-over'); });
        uploader.addEventListener('dragleave', () => uploader.classList.remove('drag-over'));
        uploader.addEventListener('drop', (e) => {
            e.preventDefault();
            uploader.classList.remove('drag-over');
            if (e.dataTransfer.files.length) {
                fileInput.files = e.dataTransfer.files;
                updatePreview(fileInput.files[0]);
            }
        });
    });
});

function showToast(message, isSuccess) {
    const toast = document.getElementById('toast-notification');
    if (!toast) return;
    toast.textContent = message;
    toast.className = 'show ' + (isSuccess ? 'success' : 'error');
    setTimeout(() => { toast.className = toast.className.replace('show', ''); }, 3000);
}
</script>
</body>
</html>