<?php
require 'db_connect.php';
session_start();

// যদি ব্যবহারকারী ইতিমধ্যে লগইন করা থাকে, তাকে ড্যাশবোর্ডে পাঠিয়ে দেওয়া হবে
if (isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email']);
    $password = $_POST['password'];

    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    // ব্যবহারকারীকে খুঁজে পাওয়া গেলে এবং পাসওয়ার্ড সঠিক হলে লগইন হবে
    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['username'] = $user['username'];
        header("Location: index.php");
        exit();
    } else {
        $error = "Invalid email or password.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Login</title>
    <link rel="stylesheet" href="css/style.css?v=<?php echo filemtime('css/style.css'); ?>">
</head>
<body class="auth-body">
    <div class="auth-container">
        <h2 class="auth-title">Dashboard Login</h2>
        <?php if (!empty($error)): ?>
            <div class="auth-errors"><p><?php echo $error; ?></p></div>
        <?php endif; ?>
        <?php if (isset($_GET['registration']) && $_GET['registration'] === 'success'): ?>
            <div class="auth-success"><p>Registration successful! Please login.</p></div>
        <?php endif; ?>
        <form action="login.php" method="POST">
            <div class="form-group">
                <label for="email">Email</label>
                <input type="email" id="email" name="email" required>
            </div>
            <div class="form-group">
                <label for="password">Password</label>
                <input type="password" id="password" name="password" required>
            </div>
            <button type="submit" class="btn btn-primary auth-btn">Login</button>
        </form>
        <p class="auth-switch">Don't have an account? <a href="register.php">Register here</a></p>
    </div>
</body>
</html>