<?php
// ব্যবহারকারী লগইন করা আছে কিনা তা পরীক্ষা করা
require 'auth_check.php';
// ডেটাবেস সংযোগ ফাইল যুক্ত করা
require 'db_connect.php'; 

// হেডার ও সাইডবার টেমপ্লেট যুক্ত করা
include 'templates/header.php';
include 'templates/sidebar.php';

$user_id = $_SESSION['user_id'];

// শুধুমাত্র ব্যবহারকারীর তৈরি করা (ডিফল্ট নয়) লিঙ্কগুলো আনা হচ্ছে
$stmt = $pdo->prepare("SELECT * FROM payment_links WHERE user_id = ? AND is_default = 0 ORDER BY id DESC");
$stmt->execute([$user_id]);
$payment_links = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!-- পেমেন্ট লিঙ্ক পেজের মূল কন্টেন্ট -->
<div class="page-container">
    <div class="page-header">
        <div>
            <p class="breadcrumbs">Payment Links > List</p>
            <h1 class="page-title">Payment Links</h1>
        </div>
        <!-- ডান পাশের বাটন গ্রুপ -->
        <div class="page-header-actions">
            <a href="#" class="btn btn-secondary" id="copyDefaultLinkBtn">
                <i class="far fa-copy"></i> Copy Default Link
            </a>
            <!-- .htaccess এর জন্য .php ছাড়া লিঙ্ক ব্যবহার করা হচ্ছে -->
            <a href="create_payment_link" class="btn btn-primary">
                <i class="fas fa-plus"></i> New payment link
            </a>
        </div>
    </div>

    <div class="content-card">
        <div class="card-toolbar">
            <div class="toolbar-left"></div>
            <div class="toolbar-right" style="display: flex; align-items: center; gap: 15px;">
                <div class="search-box">
                    <i class="fas fa-search"></i>
                    <input type="text" placeholder="Search">
                </div>
                <i class="fas fa-bars icon-btn"></i>
            </div>
        </div>

        <table class="data-table">
            <thead>
                <tr>
                    <th><input type="checkbox"></th>
                    <th>Product name <i class="fas fa-chevron-down"></i></th>
                    <th>Product description <i class="fas fa-chevron-down"></i></th>
                    <th>Amount <i class="fas fa-chevron-down"></i></th>
                    <th>Quantity <i class="fas fa-chevron-down"></i></th>
                    <th>Status</th>
                    <th></th> <!-- Actions কলামের জন্য ফাঁকা হেডার -->
                </tr>
            </thead>
            <tbody>
                <?php if (count($payment_links) > 0): ?>
                    <?php foreach ($payment_links as $link): ?>
                        <tr>
                            <td><input type="checkbox"></td>
                            <td><?php echo htmlspecialchars($link['product_name']); ?></td>
                            <td><?php echo htmlspecialchars($link['product_description']); ?></td>
                            <td><?php echo htmlspecialchars($link['currency']); ?> <?php echo number_format($link['amount'], 2); ?></td>
                            <td><?php echo htmlspecialchars($link['quantity']); ?></td>
                            <td>
                                <label class="toggle-switch">
                                    <input type="checkbox" <?php echo $link['status'] ? 'checked' : ''; ?>>
                                    <span class="slider"></span>
                                </label>
                            </td>
                            <td class="actions" style="text-align: right;">
                                <a href="edit_payment_link?id=<?php echo $link['id']; ?>" class="action-edit"><i class="fas fa-pencil-alt"></i> Edit</a>
                                <a href="#" class="action-copy" data-id="<?php echo $link['id']; ?>"><i class="far fa-copy"></i> Copy</a>
                                <a href="delete_payment_link?id=<?php echo $link['id']; ?>" class="action-delete" onclick="return confirm('Are you sure?');"><i class="fas fa-trash-alt"></i> Delete</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="7" style="text-align:center; padding: 20px;">No payment links have been created yet.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
        
        <div class="card-footer">
            <div class="pagination-controls">
                <span>Per page</span>
                <select><option selected>10</option><option>20</option><option>50</option></select>
            </div>
        </div>
    </div>
</div>

</div> <!-- .main-content বন্ধ করার ট্যাগ -->

<!-- টোস্ট নোটিফিকেশনের জন্য HTML এলিমেন্ট -->
<div id="toast-notification"></div>

<script src="js/main.js?v=<?php echo filemtime('js/main.js'); ?>"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const copyDefaultLinkBtn = document.getElementById('copyDefaultLinkBtn');
    
    if(copyDefaultLinkBtn) {
        copyDefaultLinkBtn.addEventListener('click', function(e) {
            e.preventDefault();
            
            // AJAX দিয়ে সার্ভার থেকে ডিফল্ট লিঙ্কের আইডি আনা হচ্ছে
            fetch('get_default_link.php')
            .then(response => response.json())
            .then(data => {
                if (data.success && data.unique_id) {
                    const baseUrl = window.location.origin + window.location.pathname.replace('payment_links.php', '').replace('payment_links', '');
                    const defaultLink = baseUrl + 'paymentlink/pay/' + data.unique_id;

                    navigator.clipboard.writeText(defaultLink).then(() => {
                        showToast('Default link copied to clipboard!', true);
                    });
                } else {
                    showToast(data.message || 'Could not generate default link.', false);
                }
            })
            .catch(() => showToast('An error occurred.', false));
        });
    }

    document.querySelectorAll('.action-copy').forEach(button => {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            const linkId = this.dataset.id;
            fetch('get_payment_link.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: 'id=' + linkId
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    const cleanUrl = data.url.replace('pay.php?link_id=', 'pay/');
                    navigator.clipboard.writeText(cleanUrl).then(() => {
                        showToast('Payment link copied!', true);
                    });
                } else {
                    showToast('Could not retrieve the link.', false);
                }
            });
        });
    });

    function showToast(message, isSuccess) {
        const toast = document.getElementById('toast-notification');
        if (!toast) return;
        toast.textContent = message;
        toast.className = 'show ' + (isSuccess ? 'success' : 'error');
        setTimeout(() => {
            toast.className = toast.className.replace('show', '');
        }, 3000);
    }
});
</script>
</body>
</html>