<?php
require 'db_connect.php';
session_start();

if (isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}

$errors = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    $password_confirm = $_POST['password_confirm'];

    if ($password !== $password_confirm) {
        $errors[] = "Passwords do not match!";
    }

    $stmt = $pdo->prepare("SELECT id FROM users WHERE email = ?");
    $stmt->execute([$email]);
    if ($stmt->fetch()) {
        $errors[] = "Email address is already in use.";
    }

    if (empty($errors)) {
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);
        
        // Users টেবিলে নতুন ব্যবহারকারী যুক্ত করা হচ্ছে
        $sql = "INSERT INTO users (username, email, password) VALUES (?, ?, ?)";
        $stmt = $pdo->prepare($sql);
        
        if ($stmt->execute([$username, $email, $hashed_password])) {
            
            // ★★★ পরিবর্তন এখানে শুরু ★★★

            // এইমাত্র যে ব্যবহারকারী তৈরি হলো, তার আইডি (user_id) বের করা হচ্ছে
            $user_id = $pdo->lastInsertId();

            // একটি নতুন, ইউনিক API Key তৈরি করা হচ্ছে
            $new_api_key = bin2hex(random_bytes(32));

            // settings টেবিলে এই user_id এবং new_api_key টি সেভ করা হচ্ছে
            $sql_settings = "INSERT INTO settings (user_id, api_key) VALUES (?, ?)";
            $stmt_settings = $pdo->prepare($sql_settings);
            $stmt_settings->execute([$user_id, $new_api_key]);

            // ★★★ পরিবর্তন এখানে শেষ ★★★


            // সফলভাবে রেজিস্ট্রেশন হওয়ার পর লগইন পেজে পাঠানো হচ্ছে
            header("Location: login.php?registration=success");
            exit();

        } else {
            $errors[] = "Registration failed. Please try again.";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Create an Account</title>
    <link rel="stylesheet" href="css/style.css?v=<?php echo filemtime('css/style.css'); ?>">
</head>
<body class="auth-body">
    <div class="auth-container">
        <h2 class="auth-title">Create an Account</h2>
        <?php if (!empty($errors)): ?>
            <div class="auth-errors">
                <?php foreach ($errors as $error): ?>
                    <p><?php echo $error; ?></p>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
        <form action="register.php" method="POST">
            <div class="form-group">
                <label for="username">Username</label>
                <input type="text" id="username" name="username" required>
            </div>
            <div class="form-group">
                <label for="email">Email</label>
                <input type="email" id="email" name="email" required>
            </div>
            <div class="form-group">
                <label for="password">Password</label>
                <input type="password" id="password" name="password" required>
            </div>
            <div class="form-group">
                <label for="password_confirm">Confirm Password</label>
                <input type="password" id="password_confirm" name="password_confirm" required>
            </div>
            <button type="submit" class="btn btn-primary auth-btn">Register</button>
        </form>
        <p class="auth-switch">Already have an account? <a href="login.php">Login here</a></p>
    </div>
</body>
</html>