<?php
header('Content-Type: application/json');
require '../db_connect.php';

try {
    $license_key = $_POST['license_key'] ?? '';
    $current_version = $_POST['current_version'] ?? '0.0.0';

    if (empty($license_key)) {
        throw new Exception('License key is required.', 401);
    }
    
    $stmt_user = $pdo->prepare("SELECT id FROM users WHERE license_key = ? AND license_status = 'active'");
    $stmt_user->execute([$license_key]);
    if (!$stmt_user->fetch()) {
        throw new Exception('Invalid or inactive license key.', 403);
    }

    // ★★★ নতুন পরিবর্তন: update_type কলামটিও সিলেক্ট করা হচ্ছে ★★★
    $stmt_latest = $pdo->query("SELECT *, update_type FROM updates ORDER BY STR_TO_DATE(created_at, '%Y-%m-%d %H:%i:%s') DESC, id DESC LIMIT 1");
    $latest_update = $stmt_latest->fetch(PDO::FETCH_ASSOC);

    $is_new_version_available = false;
    if ($latest_update) {
        if (version_compare($latest_update['version'], $current_version, '>')) {
            $is_new_version_available = true;
        }
    }
    
    if ($latest_update && $is_new_version_available) {
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https" : "http";
        $host = $_SERVER['HTTP_HOST'];
        $base_project_path = '/dashboard_project';
        $base_url = rtrim("{$protocol}://{$host}", '/') . '/' . ltrim($base_project_path, '/');
        $manifest_filename = 'update-v' . $latest_update['version'] . '_manifest.json';

        echo json_encode([
            'update_available' => true,
            'version' => $latest_update['version'],
            // ★★★ নতুন পরিবর্তন: update_type রেসপন্সে যুক্ত করা হয়েছে ★★★
            'update_type' => $latest_update['update_type'], 
            'download_url' => $base_url . '/' . $latest_update['zip_path'],
            'manifest_url' => $base_url . '/updates/' . $manifest_filename,
            'sql_migration' => $latest_update['sql_migration']
        ]);
    } else {
        echo json_encode(['update_available' => false]);
    }

} catch (Exception $e) {
    http_response_code($e->getCode() ?: 500);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}