<?php
// create_instance_admin.php

header('Content-Type: application/json');
require '../db_connect.php';

try {
    // সেলফ-হোস্টেড সাইট থেকে পাঠানো ডেটা গ্রহণ করা
    $license_key = $_POST['license_key'] ?? '';
    // ★★★ সমাধান: license_status গ্রহণ করা হচ্ছে ★★★
    $license_status = $_POST['license_status'] ?? 'active'; 

    if (empty($license_key)) {
        http_response_code(400); // Bad Request
        throw new Exception('License key is required.');
    }

    // এই লাইসেন্স কী দিয়ে আগে থেকেই কোনো ইউজার আছে কিনা তা পরীক্ষা করা
    $stmt_check = $pdo->prepare("SELECT id FROM users WHERE license_key = ?");
    $stmt_check->execute([$license_key]);
    if ($stmt_check->fetch()) {
        http_response_code(409); // Conflict
        throw new Exception('This license key is already associated with another user.');
    }
    
    // ডাটাবেস ট্রানজেকশন শুরু করা
    $pdo->beginTransaction();

    // একটি ইউনিক ইউজারনেম এবং নিরাপদ পাসওয়ার্ড তৈরি করা
    $username = 'admin_' . substr(bin2hex(random_bytes(4)), 0, 6);
    $password = bin2hex(random_bytes(6)); // 12-character password
    $hashed_password = password_hash($password, PASSWORD_DEFAULT);
    
    // একটি ডাইনামিক ইমেইল তৈরি করা (ঐচ্ছিক)
    $email = 'user_' . time() . '@' . parse_url($_SERVER['HTTP_REFERER'] ?? 'selfhost.com', PHP_URL_HOST);

    // ★★★ সমাধান: users টেবিলে license_status সহ ডেটা ইনসার্ট করা হচ্ছে ★★★
    $sql_user = "INSERT INTO users (username, email, password, license_key, license_status) VALUES (?, ?, ?, ?, ?)";
    $stmt_user = $pdo->prepare($sql_user);
    $stmt_user->execute([$username, $email, $hashed_password, $license_key, $license_status]);
    
    $user_id = $pdo->lastInsertId();

    // এই নতুন ইউজারের জন্য একটি স্বতন্ত্র API Key তৈরি করা
    $new_api_key = bin2hex(random_bytes(32));

    // `settings` টেবিলে user_id এবং new_api_key সেভ করা
    $sql_settings = "INSERT INTO settings (user_id, api_key) VALUES (?, ?)";
    $stmt_settings = $pdo->prepare($sql_settings);
    $stmt_settings->execute([$user_id, $new_api_key]);

    // ট্রানজেকশন সফলভাবে সম্পন্ন করা
    $pdo->commit();

    // সফলভাবে তৈরি হওয়ার পর ইউজারনেম ও পাসওয়ার্ড ফেরত পাঠানো
    echo json_encode([
        'success' => true, 
        'message' => 'Admin user created successfully.',
        'credentials' => [
            'username' => $username,
            'password' => $password
        ]
    ]);

} catch (Exception $e) {
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }
    $statusCode = http_response_code();
    if ($statusCode < 400) { $statusCode = 500; }
    
    http_response_code($statusCode);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>