<?php
header('Content-Type: application/json');
require '../db_connect.php';

// API Key Authentication
$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';
if (empty($api_key)) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'API Key is missing.']);
    exit();
}

$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting = $stmt_user->fetch(PDO::FETCH_ASSOC);

if (!$setting) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Invalid API Key.']);
    exit();
}
$user_id = $setting['user_id'];

$response = ['success' => false, 'message' => 'Could not retrieve default link.'];

try {
    $stmt = $pdo->prepare("SELECT unique_link_id FROM payment_links WHERE user_id = ? AND is_default = 1 LIMIT 1");
    $stmt->execute([$user_id]);
    $link = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($link && !empty($link['unique_link_id'])) {
        $unique_id = $link['unique_link_id'];
    } else {
        $unique_id = 'default-' . bin2hex(random_bytes(12));
        $pdo->prepare("INSERT INTO payment_links (user_id, product_name, unique_link_id, is_default, status) VALUES (?, 'Default Payment Link', ?, 1, 1)")->execute([$user_id, $unique_id]);
    }
    
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https" : "http";
    $host = $_SERVER['HTTP_HOST'];
    $directory = rtrim(dirname(dirname($_SERVER['PHP_SELF'])), '/\\');
    
    $response['success'] = true;
    $response['url'] = "{$protocol}://{$host}{$directory}/paymentlink/pay/{$unique_id}";
    $response['message'] = 'Default link retrieved.';

} catch (PDOException $e) {
    $response['message'] = 'Database error.';
}

echo json_encode($response);
?>