<?php
header('Content-Type: application/json');
require '../db_connect.php';

try {
    // ক্লায়েন্ট থেকে পাঠানো লাইসেন্স কী গ্রহণ করা
    $license_key = $_POST['license_key'] ?? '';
    $file_name = $_POST['file_name'] ?? '';

    if (empty($license_key) || empty($file_name)) {
        http_response_code(400);
        throw new Exception('License key and file name are required.');
    }

    // লাইসেন্স কী দিয়ে ব্যবহারকারীকে যাচাই করা (নিরাপত্তার জন্য)
    $stmt_user = $pdo->prepare("SELECT id FROM users WHERE license_key = ?");
    $stmt_user->execute([$license_key]);
    if (!$stmt_user->fetch()) {
        http_response_code(403);
        throw new Exception('Invalid or unauthorized license key.');
    }

    // `file_templates` টেবিল থেকে ফাইলের কন্টেন্ট আনা
    $stmt_template = $pdo->prepare("SELECT content FROM file_templates WHERE file_name = ?");
    $stmt_template->execute([$file_name]);
    $template = $stmt_template->fetch(PDO::FETCH_ASSOC);

    if ($template) {
        echo json_encode([
            'success' => true,
            'content' => $template['content']
        ]);
    } else {
        http_response_code(404);
        throw new Exception("The requested file template '{$file_name}' was not found on the central server.");
    }

} catch (Exception $e) {
    $statusCode = http_response_code();
    if ($statusCode < 400) { $statusCode = 500; }
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>