<?php
/**
 * API Endpoint for Validating User Login from Self-Hosted Instances
 * Version 2.1 - Returns user_id and api_key on successful validation.
 */

header('Content-Type: application/json');
require '../db_connect.php';

$username = $_POST['username'] ?? '';
$password = $_POST['password'] ?? '';
$license_key = $_POST['license_key'] ?? ''; 

if (empty($username) || empty($password) || empty($license_key)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Username, password, and license key are required for validation.']);
    exit();
}

try {
    // ব্যবহারকারীকে ইউজারনেম এবং লাইসেন্স কী উভয়ই মিলিয়ে খোঁজা হচ্ছে
    $stmt = $pdo->prepare("SELECT id, password FROM users WHERE username = ? AND license_key = ?");
    $stmt->execute([$username, $license_key]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    // পাসওয়ার্ড যাচাই করা হচ্ছে
    if ($user && password_verify($password, $user['password'])) {
        
        // ★★★ নতুন সংযোজন: API Key খুঁজে বের করা ★★★
        $stmt_key = $pdo->prepare("SELECT api_key FROM settings WHERE user_id = ?");
        $stmt_key->execute([$user['id']]);
        $setting = $stmt_key->fetch(PDO::FETCH_ASSOC);
        $api_key = $setting['api_key'] ?? null;
        
        // ★★★ নতুন সংযোজন: রেসপন্সে user_id এবং api_key দুটোই পাঠানো হচ্ছে ★★★
        echo json_encode([
            'success' => true,
            'message' => 'Login successful.',
            'user_id' => $user['id'],
            'api_key' => $api_key // এই লাইনটি নতুন
        ]);

    } else {
        // ব্যর্থ লগইন
        http_response_code(401);
        echo json_encode(['success' => false, 'message' => 'Invalid credentials or license mismatch.']);
    }

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Central Server Authentication Error.']);
}
?>