<?php
// checkout.php

// ডেটাবেস সংযোগ এবং সেশন শুরু করা
require 'db_connect.php';
session_start();

// --- Configuration ---
define('FEE_PER_TRANSACTION_BDT', 1.00);
define('USD_TO_BDT_RATE_FOR_FEE', 120);

// Helper function for fee deduction
function deduct_fee_and_log($pdo, $user_id, $transaction_db_id) {
    // Step 1: Calculate total available credits
    $free_credits = 50; // All new users get 50 free credits
    $stmt_purchased = $pdo->prepare("SELECT COALESCE(SUM(amount_bdt), 0) as total_purchased FROM user_funds WHERE user_id = ? AND status = 'completed' AND transaction_unique_id LIKE 'manual_purchase_%'");
    $stmt_purchased->execute([$user_id]);
    $purchased_credits = $stmt_purchased->fetchColumn();
    $total_available_credits = $free_credits + $purchased_credits;

    // Step 2: Calculate used credits
    $stmt_used = $pdo->prepare("SELECT COUNT(id) FROM credit_transactions WHERE user_id = ? FOR UPDATE");
    $stmt_used->execute([$user_id]);
    $used_credits = $stmt_used->fetchColumn();

    if ($used_credits >= $total_available_credits) {
        throw new Exception("Insufficient credits to cover transaction fee.");
    }

    // Step 3: Log credit usage
    $fee_bdt = FEE_PER_TRANSACTION_BDT;
    $fee_usd = $fee_bdt / USD_TO_BDT_RATE_FOR_FEE;
    $stmt_log = $pdo->prepare(
        "INSERT INTO credit_transactions (user_id, payment_transaction_id, cost_bdt, cost_usd, credits_deducted, description)
         VALUES (?, ?, ?, ?, 1, 'API Payment Verification Fee')"
    );
    $stmt_log->execute([$user_id, $transaction_db_id, $fee_bdt, $fee_usd]);
    return true;
}


$payment_successful = false;
$final_payment_data = null;
$toast_message = null;

// bKash Tokenized Callback হ্যান্ডেল করার জন্য
if (isset($_GET['bkash_callback']) && $_GET['bkash_callback'] == '1') {
    $paymentID = $_GET['paymentID'] ?? null;
    $status = $_GET['status'] ?? 'failed';
    $trx_id = $_GET['trx_id'] ?? null;

    if ($status !== 'success') {
        if ($trx_id) {
            header("Location: checkout.php?trx_id={$trx_id}&bkash_status=cancelled");
        } else {
            header("Location: payment_cancelled.php");
        }
        exit();
    }

    $redirect_url = 'payment_cancelled.php'; 
    if ($trx_id) {
        $stmt_urls = $pdo->prepare("SELECT success_url, cancel_url FROM transactions WHERE unique_id = ?");
        $stmt_urls->execute([$trx_id]);
        $urls = $stmt_urls->fetch(PDO::FETCH_ASSOC);
        if ($urls) {
            $redirect_url = $urls['cancel_url'] ?: 'payment_cancelled.php';
        }
    }

    if ($status === 'success' && $paymentID && $trx_id) {
        try {
            $stmt_trans = $pdo->prepare("SELECT * FROM transactions WHERE unique_id = ?");
            $stmt_trans->execute([$trx_id]);
            $transaction = $stmt_trans->fetch(PDO::FETCH_ASSOC);

            if ($transaction) {
                $stmt_gateway = $pdo->prepare("SELECT * FROM gateways WHERE user_id = ? AND gateway_key = 'bkash_merchant_tokenized'");
                $stmt_gateway->execute([$transaction['user_id']]);
                $creds = $stmt_gateway->fetch(PDO::FETCH_ASSOC);

                if ($creds) {
                    $env = $creds['test_mode'] ? 'sandbox' : 'pay';
                    $token_url = "https://tokenized.{$env}.bka.sh/v1.2.0-beta/tokenized/checkout/token/grant";
                    $token_req_body = json_encode(['app_key' => $creds['app_key'], 'app_secret' => $creds['app_secret']]);
                    $token_headers = ['Content-Type: application/json', 'username: ' . $creds['username'], 'password: ' . $creds['password']];
                    $ch = curl_init(); curl_setopt_array($ch, [CURLOPT_URL => $token_url, CURLOPT_HTTPHEADER => $token_headers, CURLOPT_POSTFIELDS => $token_req_body, CURLOPT_RETURNTRANSFER => true, CURLOPT_POST => 1]);
                    $token_res = curl_exec($ch); $token_data = json_decode($token_res, true); curl_close($ch);

                    if (isset($token_data['id_token'])) {
                        $execute_url = "https://tokenized.{$env}.bka.sh/v1.2.0-beta/tokenized/checkout/execute";
                        $execute_req_body = json_encode(['paymentID' => $paymentID]);
                        $execute_headers = ['Content-Type: application/json', 'Authorization: Bearer ' . $token_data['id_token'], 'X-App-Key: ' . $creds['app_key']];
                        $ch_exec = curl_init(); curl_setopt_array($ch_exec, [CURLOPT_URL => $execute_url, CURLOPT_HTTPHEADER => $execute_headers, CURLOPT_POSTFIELDS => $execute_req_body, CURLOPT_RETURNTRANSFER => true, CURLOPT_POST => 1]);
                        $execute_res = curl_exec($ch_exec); $execute_data = json_decode($execute_res, true); curl_close($ch_exec);

                        if (isset($execute_data['transactionStatus']) && $execute_data['transactionStatus'] === 'Completed') {
                            $pdo->beginTransaction();
                            try {
                                $pdo->prepare("UPDATE transactions SET status = 'completed', user_submitted_trxid = ? WHERE unique_id = ?")->execute([$execute_data['trxID'], $trx_id]);
                                
                                $meta_data = json_decode($transaction['meta_data'], true);
                                $source = $meta_data['source'] ?? 'api';
                                if ($source !== 'user_funding') {
                                    deduct_fee_and_log($pdo, $transaction['user_id'], $transaction['id']);
                                }
                                
                                $pdo->commit();

                                $wordpress_order_id = $meta_data['order_id'] ?? null;
                                $wordpress_webhook_url = $meta_data['webhook_url'] ?? null;
                                if (($source === 'api' || $source === 'whmcs') && $wordpress_order_id && $wordpress_webhook_url) {
                                    $webhook_payload = json_encode(['order_id' => $wordpress_order_id, 'transaction_id' => $execute_data['trxID'], 'status' => 'completed']);
                                    $ch_webhook = curl_init($wordpress_webhook_url);
                                    curl_setopt_array($ch_webhook, [CURLOPT_RETURNTRANSFER => true, CURLOPT_POST => true, CURLOPT_POSTFIELDS => $webhook_payload, CURLOPT_HTTPHEADER => ['Content-Type: application/json'], CURLOPT_TIMEOUT => 10]);
                                    curl_exec($ch_webhook);
                                    curl_close($ch_webhook);
                                }
                                
                                $payment_successful = true;
                                $final_payment_data = ['success' => true, 'source' => $source, 'redirect_url' => $transaction['success_url'], 'transaction_id' => $execute_data['trxID']];
                            } catch (Exception $e) {
                                $pdo->rollBack();
                                error_log("Fee deduction failed for bKash Tokenized trx_id {$trx_id}: " . $e->getMessage());
                            }
                        }
                    }
                }
            }
        } catch (Exception $e) {}
    }
    if (!$payment_successful) {
        header("Location: " . $redirect_url);
        exit();
    }
}

// Nagad Callback হ্যান্ডেল করার জন্য
if (isset($_GET['nagad_callback']) && $_GET['nagad_callback'] == '1') {
    $status = $_GET['status'] ?? 'failed';
    $payment_ref_id = $_GET['payment_ref_id'] ?? null;
    $order_id_from_nagad = $_GET['order_id'] ?? null;
    $trx_id = $order_id_from_nagad ? substr($order_id_from_nagad, 0, -4) : null;

    if ($status !== 'Success') {
        if($trx_id) { header("Location: checkout.php?trx_id={$trx_id}&nagad_status=cancelled"); }
        else { header("Location: payment_cancelled.php"); }
        exit();
    }

    $redirect_url = $trx_id ? "checkout.php?trx_id={$trx_id}&nagad_status=failed" : 'payment_cancelled.php';

    if ($status === 'Success' && $payment_ref_id && $trx_id) {
        try {
            $stmt_trans = $pdo->prepare("SELECT * FROM transactions WHERE unique_id = ?");
            $stmt_trans->execute([$trx_id]);
            $transaction = $stmt_trans->fetch(PDO::FETCH_ASSOC);

            if ($transaction) {
                $stmt_gateway = $pdo->prepare("SELECT * FROM gateways WHERE user_id = ? AND gateway_key = 'nagad_merchant'");
                $stmt_gateway->execute([$transaction['user_id']]);
                $creds = $stmt_gateway->fetch(PDO::FETCH_ASSOC);
                
                $nagad_url_prefix = ($creds && $creds['test_mode']) ? 'https://sandbox-ssl.mynagad.com' : 'https://ssl.mynagad.com';
                $verify_url = "{$nagad_url_prefix}/api/dfs/verify/payment/" . $payment_ref_id;

                $ch = curl_init(); curl_setopt_array($ch, [CURLOPT_URL => $verify_url, CURLOPT_RETURNTRANSFER => true]);
                $verify_res = curl_exec($ch); curl_close($ch);
                $verify_data = json_decode($verify_res, true);

                if (isset($verify_data['status']) && $verify_data['status'] === 'Success' && (float)$verify_data['amount'] == (float)$transaction['amount']) {
                    $pdo->beginTransaction();
                    try {
                        $pdo->prepare("UPDATE transactions SET status = 'completed', user_submitted_trxid = ? WHERE unique_id = ?")->execute([$verify_data['issuerPaymentRefNo'], $trx_id]);
                        
                        $meta_data = json_decode($transaction['meta_data'], true);
                        $source = $meta_data['source'] ?? 'api';
                        if ($source !== 'user_funding') {
                            deduct_fee_and_log($pdo, $transaction['user_id'], $transaction['id']);
                        }

                        $pdo->commit();
                        
                        $wordpress_order_id = $meta_data['order_id'] ?? null;
                        $wordpress_webhook_url = $meta_data['webhook_url'] ?? null;
                        if (($source === 'api' || $source === 'whmcs') && $wordpress_order_id && $wordpress_webhook_url) {
                            $webhook_payload = json_encode(['order_id' => $wordpress_order_id, 'transaction_id' => $verify_data['issuerPaymentRefNo'], 'status' => 'completed']);
                            $ch_webhook = curl_init($wordpress_webhook_url);
                            curl_setopt_array($ch_webhook, [CURLOPT_RETURNTRANSFER => true, CURLOPT_POST => true, CURLOPT_POSTFIELDS => $webhook_payload, CURLOPT_HTTPHEADER => ['Content-Type: application/json'], CURLOPT_TIMEOUT => 10]);
                            curl_exec($ch_webhook);
                            curl_close($ch_webhook);
                        }
                        
                        $payment_successful = true;
                        $final_payment_data = ['success' => true, 'source' => $source, 'redirect_url' => $transaction['success_url'], 'transaction_id' => $verify_data['issuerPaymentRefNo']];
                    } catch (Exception $e) {
                        $pdo->rollBack();
                        error_log("Fee deduction failed for Nagad trx_id {$trx_id}: " . $e->getMessage());
                    }
                }
            }
        } catch (Exception $e) {}
    }
    if (!$payment_successful) {
        header("Location: " . $redirect_url);
        exit();
    }
}

// === Main Logic for Page Load & Refresh ===
$unique_id = $_GET['trx_id'] ?? null;
if (!$unique_id) { die("Invalid payment link. Transaction ID is missing."); }

if (isset($_GET['bkash_status']) && $_GET['bkash_status'] === 'cancelled') {
    $toast_message = "Payment cancelled with bKash.";
} elseif (isset($_GET['nagad_status']) && $_GET['nagad_status'] === 'cancelled') {
    $toast_message = "Payment cancelled with Nagad.";
}

$stmt = $pdo->prepare("SELECT * FROM transactions WHERE unique_id = ?");
$stmt->execute([$unique_id]);
$transaction = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$transaction) {
    die("This payment link is invalid or does not exist.");
}

$is_cancelled_by_link = isset($_GET['status']) && $_GET['status'] === 'cancelled';
$meta_data = json_decode($transaction['meta_data'], true);
$source = $meta_data['source'] ?? 'api';
$is_payment_link = ($source === 'payment_link' || $source === 'default_payment_link');

// If transaction is completed, prepare the data for the success view
if ($transaction['status'] === 'completed') {
    $payment_successful = true;
    
    $stmt_gateway_info = $pdo->prepare("SELECT display_name FROM gateways WHERE user_id = ? LIMIT 1");
    $stmt_gateway_info->execute([$transaction['user_id']]);
    $gateway_info = $stmt_gateway_info->fetch(PDO::FETCH_ASSOC);

    $final_payment_data = [
        'success' => true,
        'source' => $source,
        'redirect_url' => $transaction['success_url'],
        'name' => $transaction['customer_name'],
        'email' => $transaction['customer_email'],
        'phone' => $transaction['phone'] ?? '01763705151',
        'amount' => $transaction['amount'],
        'transaction_id' => $transaction['user_submitted_trxid'],
        'payment_method' => $gateway_info['display_name'] ?? 'Bkash Personal'
    ];
}

$site_name = 'SecureSoftPayt';
$round_logo_path = 'images/logo-placeholder-round.png';

$user_id = $transaction['user_id'];
$amount = $transaction['amount'];
$cancel_url = $transaction['cancel_url'];

$stmt_brand = $pdo->prepare("SELECT bs.site_name, bl.round_logo FROM users u LEFT JOIN brand_settings bs ON u.id = bs.user_id LEFT JOIN brand_logos bl ON u.id = bl.user_id WHERE u.id = ?");
$stmt_brand->execute([$user_id]);
$brand_info = $stmt_brand->fetch(PDO::FETCH_ASSOC);

if ($brand_info) {
    $site_name = !empty($brand_info['site_name']) ? $brand_info['site_name'] : $site_name;
    $round_logo_path = !empty($brand_info['round_logo']) ? $brand_info['round_logo'] : $round_logo_path;
}

$stmt_gateways = $pdo->prepare("SELECT * FROM gateways WHERE user_id = ? AND status = 1");
$stmt_gateways->execute([$user_id]);
$gateways = $stmt_gateways->fetchAll(PDO::FETCH_ASSOC);

function get_gateway_logo($key) {
    $logos = ['bkash_personal' => 'images/bkash.png', 'nagad_personal' => 'images/nagad.png', 'rocket_personal' => 'images/rocket.png', 'upay_personal' => 'images/upay.png', 'bkash_merchant_tokenized' => 'images/bkash.png', 'nagad_merchant' => 'images/nagad.png', 'bkash_merchant_checkout' => 'images/bkash.png'];
    return $logos[$key] ?? 'images/default.png';
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Complete Your Payment</title>
    <script src="https://scripts.pay.bka.sh/versions/1.2.0-beta/checkout/bKash-checkout.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        /* General Body & Container */
        .checkout-body { background-color: #f0f4f9; display: flex; justify-content: center; align-items: center; min-height: 100vh; padding: 20px; font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif; }
        .checkout-container { background-color: #ffffff; width: 100%; max-width: 850px; padding: 40px; border-radius: 16px; box-shadow: 0 10px 30px rgba(0,0,0,0.08); }

        /* Payment Success View Styles */
        .payment-success-container { display: flex; gap: 40px; align-items: center; }
        .success-left-panel { flex: 1; text-align: left; position: relative; overflow: hidden; padding-bottom: 80px; }
        .success-left-panel h1 { font-size: 36px; color: #c9302c; margin-top: 0; margin-bottom: 10px; font-weight: 600; }
        .success-left-panel p { font-size: 16px; color: #555; margin-bottom: 25px; line-height: 1.5; }
        .main-success-img { max-width: 100%; height: auto; border-radius: 8px; position: relative; z-index: 2; }
        .decorative-wave { position: absolute; bottom: -80px; left: -50px; width: 110%; height: auto; z-index: 1; pointer-events: none; }
        .success-right-panel { flex: 1.1; background-color: #f8f9fa; border-radius: 12px; padding: 25px 30px; border: 1px solid #e9ecef; }
        .success-right-panel h2 { text-align: center; font-size: 22px; color: #333; margin-top: 0; margin-bottom: 20px; padding-bottom: 15px; border-bottom: 1px solid #dee2e6; font-weight: 500;}
        .info-item { display: flex; justify-content: space-between; align-items: center; font-size: 15px; padding: 13px 0; border-bottom: 1px dashed #ced4da; }
        .info-item:last-child { border-bottom: none; }
        .info-item .label { color: #6c757d; }
        .info-item .value { color: #212529; font-weight: 500; }
        .info-item .status-completed { font-weight: bold; color: #28a745; }

        /* Payment Cancellation View */
        .payment-cancelled-view { text-align: center; padding: 40px 20px; }
        .cancel-illustration { max-width: 250px; margin-bottom: 30px; }
        .cancel-title { font-size: 48px; font-weight: 700; color: #343a40; margin: 0 0 10px 0; }
        .cancel-subtitle { font-size: 20px; color: #6c757d; margin: 0; }

        /* Other necessary styles */
        .bkash-loader{position:fixed;z-index:9999;width:100%;height:100%;background-color:#ffffffc2;left:0;top:0;background-image:url(https://res.cloudinary.com/d-coders/image/upload/v1592201998/wp-plugins/bkash.gif);background-position:center;background-repeat:no-repeat;display:none}
        .new-checkout-top-bar{position:relative;height:38px;border:1px solid #e0e0e0;border-radius:8px;background-color:#fff;margin-bottom:20px}.new-checkout-close-btn{position:absolute;top:50%;right:12px;transform:translateY(-50%);font-size:24px;color:#aaa;text-decoration:none;font-weight:400;line-height:1}.new-checkout-header{display:flex;align-items:center;gap:15px;margin-bottom:20px}.new-logo-wrapper img{width:70px;height:70px;border-radius:50%;object-fit:cover;border:1px solid #f0f0f0}.new-site-name{margin:0 0 10px;font-size:1.5rem;font-weight:600}.new-info-buttons{display:flex;flex-wrap:wrap;gap:10px}.new-info-btn{background-color:#fff;border:1px solid #dcdcdc;border-radius:20px;padding:6px 15px;font-size:14px;cursor:pointer;display:inline-flex;align-items:center;gap:6px;color:#555}.new-info-btn .fas{color:#777}.new-payment-selection-bar{background-color:#c9302c;color:#fff;text-align:center;padding:12px;border-radius:8px;font-weight:500;margin-bottom:20px}.payment-grid{display:grid;grid-template-columns:repeat(3,1fr);gap:15px;margin-bottom:25px}.payment-method{border:1px solid #dee2e6;border-radius:12px;padding:15px;display:flex;flex-direction:column;align-items:center;justify-content:center;text-align:center;cursor:pointer;transition:all .2s ease-in-out}.payment-method:hover{border-color:#0d6efd;box-shadow:0 4px 12px rgba(0,0,0,.1)}.payment-method img{max-height:50px;margin-bottom:10px}.payment-method span::before{content:'';display:block;width:90%;height:1px;background-color:#ddd;margin:0 auto 10px}.payment-method span{font-size:14px;font-weight:500;color:#333}.new-pay-button-container{margin-top:25px}.new-btn-pay{width:100%;padding:15px;background:#4285f4;color:#fff;border:none;border-radius:8px;font-size:18px;font-weight:500;cursor:pointer;transition:background-color .2s}.new-btn-pay:hover{background:#3367d6}.instruction-top-bar{display:flex;justify-content:space-between;align-items:center;height:38px;border:1px solid #e0e0e0;border-radius:8px;background-color:#fff;margin-bottom:20px;padding:0 12px}.back-button{border:none;background:0 0;font-size:18px;color:#888;cursor:pointer;padding:0}.close-button-link{border:none;background:0 0;font-size:24px;color:#aaa;text-decoration:none;font-weight:400}.instruction-logo-container{text-align:center;margin:20px 0}.main-logo{max-height:60px;width:auto}.info-boxes{display:flex;gap:15px;margin-bottom:20px}.info-box{flex:1;border:1px solid #ddd;border-radius:12px;padding:15px;display:flex;justify-content:center;align-items:center}.logo-box{justify-content:flex-start;gap:8px}.logo-box img{height:30px;width:30px;border-radius:50%;object-fit:cover}.logo-box .site-name-small{font-weight:600;color:#333}.amount-box{font-size:1.2rem;font-weight:700;color:#333}.instruction-details{background-color:#f8f9fa;border:1px solid #eee;border-radius:12px;padding:20px}.instruction-details ul{list-style:none;padding:0;margin:0}.instruction-details ul li{position:relative;padding:12px 0 12px 25px;border-bottom:1px solid #e9ecef;display:flex;align-items:center;gap:10px;color:#555}.instruction-details ul li:before{content:'•';color:#0d6efd;font-size:20px;position:absolute;left:0;top:12px;line-height:1}.instruction-details ul li:last-child{border-bottom:none}.instruction-details ul li.instruction-item-stacked{flex-direction:column;align-items:flex-start;gap:5px}.instruction-details ul li.instruction-item-stacked .value-line{width:100%;display:flex;justify-content:space-between;align-items:center}.copy-btn{background-color:#0d6efd;color:#fff;border:none;border-radius:6px;padding:5px 10px;cursor:pointer;font-size:12px;margin-left:auto}.copy-btn .far{margin-right:5px}.trx-input-group{margin-top:20px}.trx-input-group label{display:block;font-weight:700;margin-bottom:8px;color:#333}.trx-input-group input{width:100%;padding:12px;border:1px solid #ced4da;border-radius:8px;box-sizing:border-box}.verify-button{width:100%;padding:15px;background-color:#0d6efd;color:#fff;border:none;border-radius:12px;font-size:18px;font-weight:700;cursor:pointer;margin-top:20px;transition:background-color .2s}.verify-button:hover{background-color:#0b5ed7}.toast-notification{position:fixed;top:20px;right:20px;color:#fff;padding:15px 20px;border-radius:8px;z-index:1002;opacity:0;transform:translateY(-30px);transition:all .3s ease-in-out;box-shadow:0 4px 10px rgba(0,0,0,.1)}.toast-notification.show{opacity:1;transform:translateY(0)}
        .success-message{text-align:center;padding:40px 20px}.success-message i{font-size:48px;color:#28a745;margin-bottom:15px}.success-message h4{font-size:22px;margin:0 0 10px}.success-message p{color:#6c757d;font-size:16px}
    </style>
</head>
<body class="checkout-body">
    <div class="bkash-loader"></div>
    <div id="toast" class="toast-notification"></div>
    
    <div class="checkout-container">
        
        <?php if ($payment_successful && $is_payment_link): ?>
            <!-- শুধুমাত্র পেমেন্ট লিংকের জন্য এই ডিজাইনটি দেখানো হবে -->
            <div class="payment-success-container">
                <div class="success-left-panel">
                    <h1>অভিনন্দন!</h1>
                    <p>আপনার পেমেন্টের জন্য ধন্যবাদ!</p>
                    <img src="images/ha.jpg" alt="Success Illustration" class="main-success-img">
                    <img src="images/Screenshot_2025-10-19_211100-removebg-preview.png" alt="Decorative Wave" class="decorative-wave">
                </div>
                <div class="success-right-panel">
                    <h2>পেমেন্টের তথ্য</h2>
                    <div class="info-item"><span class="label">পেমেন্ট পদ্ধতি:</span><span class="value"><?php echo htmlspecialchars($final_payment_data['payment_method']); ?></span></div>
                    <div class="info-item"><span class="label">ফোন নম্বর:</span><span class="value"><?php echo htmlspecialchars($final_payment_data['phone']); ?></span></div>
                    <div class="info-item"><span class="label">ট্রানজেকশন আইডি:</span><span class="value"><?php echo htmlspecialchars($final_payment_data['transaction_id']); ?></span></div>
                    <div class="info-item"><span class="label">পরিমাণ:</span><span class="value"><?php echo number_format($final_payment_data['amount'], 2); ?> BDT</span></div>
                    <div class="info-item"><span class="label">অবস্থা:</span><span class="value status-completed">COMPLETED</span></div>
                </div>
            </div>

        <?php elseif ($payment_successful && !$is_payment_link): ?>
            <!-- API এবং বিলিং এর জন্য এই ডিজাইনটি দেখানো হবে -->
            <div class="success-message">
                <i class="fas fa-check-circle"></i>
                <h4>Your transaction is complete!</h4>
                <p id="redirect-timer">Redirecting in 5 seconds...</p>
            </div>

        <?php elseif ($is_cancelled_by_link && $is_payment_link): ?>
             <!-- শুধুমাত্র পেমেন্ট লিংকের ক্যান্সেলেশনের জন্য এই নতুন ডিজাইন -->
            <div class="payment-cancelled-view">
                <img src="images/Screenshot_2025-10-19_214428-removebg-preview.png" alt="Cancellation Illustration" class="cancel-illustration">
                <h1 class="cancel-title">Oops!</h1>
                <p class="cancel-subtitle">Your payment is cancelled</p>
            </div>
        
        <?php elseif ($transaction['status'] === 'pending'): ?>
            <!-- পেমেন্ট বাকি থাকলে এই ফর্মটি দেখানো হবে -->
            <div id="selection-view">
                <div class="new-checkout-top-bar"><a href="<?php echo htmlspecialchars($cancel_url); ?>" class="new-checkout-close-btn">&times;</a></div>
                <div class="new-checkout-header">
                    <div class="new-logo-wrapper"><img src="<?php echo htmlspecialchars($round_logo_path); ?>" alt="Brand Logo"></div>
                    <div class="new-site-info"><h2 class="new-site-name"><?php echo htmlspecialchars($site_name); ?></h2></div>
                </div>
                <div class="new-payment-selection-bar">পেমেন্ট পদ্ধতি নির্বাচন করুন</div>
                <div class="payment-grid">
                    <?php foreach ($gateways as $gateway): ?>
                        <div class="payment-method" data-gateway-name="<?php echo htmlspecialchars($gateway['display_name']); ?>" data-account-number="<?php echo htmlspecialchars($gateway['account_number']); ?>" data-logo-src="<?php echo get_gateway_logo($gateway['gateway_key']); ?>" data-gateway-key="<?php echo htmlspecialchars($gateway['gateway_key']); ?>">
                            <img src="<?php echo get_gateway_logo($gateway['gateway_key']); ?>" alt="<?php echo htmlspecialchars($gateway['display_name']); ?>">
                            <span><?php echo htmlspecialchars($gateway['display_name']); ?></span>
                        </div>
                    <?php endforeach; ?>
                </div>
                <div class="new-pay-button-container"><button class="new-btn-pay">Pay <?php echo number_format($amount, 0); ?> BDT</button></div>
            </div>
            <div id="instruction-view" style="display: none;">
                <div class="instruction-top-bar"><button id="back-to-selection" class="back-button"><i class="fas fa-arrow-left"></i></button><a href="<?php echo htmlspecialchars($cancel_url); ?>" class="close-button-link">&times;</a></div>
                <div class="instruction-logo-container"><img id="instruction-logo-main" src="" alt="Gateway Logo" class="main-logo"></div>
                <div class="info-boxes">
                    <div class="info-box logo-box"><img src="<?php echo htmlspecialchars($round_logo_path); ?>" alt="Site Logo"><span class="site-name-small"><?php echo htmlspecialchars($site_name); ?></span></div>
                    <div id="instruction-amount" class="info-box amount-box"></div>
                </div>
                <div class="instruction-details">
                    <ul>
                        <li>Go to your <b id="gateway-name-text"></b> App and choose: <b>Send Money</b></li>
                        <li class="instruction-item-stacked"><span>Enter the Number:</span><div class="value-line"><b id="instruction-number"></b> <button class="copy-btn" data-copy-target="instruction-number"><i class="far fa-copy"></i> Copy</button></div></li>
                        <li>Enter the Amount: <b id="instruction-amount-text"></b> <button class="copy-btn" data-copy-target="instruction-amount-text"><i class="far fa-copy"></i> Copy</button></li>
                        <li class="instruction-item-stacked"><span>Put the <b>Transaction ID</b> in the box below and press <b>Verify</b>.</span></li>
                    </ul>
                    <div class="trx-input-group"><label for="transaction_id">Transaction ID</label><input type="text" id="transaction_id" name="transaction_id" placeholder="Enter Transaction ID"></div>
                </div>
                <button id="verifyButton" class="verify-button">VERIFY PAYMENT</button>
            </div>
        <?php endif; ?>

    </div>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const isPaymentLink = <?php echo json_encode($is_payment_link); ?>;
        const isPaymentSuccessful = <?php echo json_encode($payment_successful); ?>;

        if (isPaymentSuccessful && !isPaymentLink) {
            // শুধুমাত্র API এবং বিলিং সফল হলে এই জাভাস্ক্রিপ্টটি কাজ করবে
            const finalData = <?php echo json_encode($final_payment_data); ?>;
            if (finalData && finalData.success) {
                let redirectUrl = finalData.redirect_url;
                if (finalData.transaction_id) {
                    const separator = redirectUrl.includes('?') ? '&' : '?';
                    redirectUrl += separator + 'transaction_id=' + encodeURIComponent(finalData.transaction_id);
                }
                
                let countdown = 5;
                const timerElement = document.getElementById('redirect-timer');
                const interval = setInterval(() => {
                    countdown--;
                    if (timerElement) timerElement.innerText = `Redirecting in ${countdown} seconds...`;
                    if (countdown <= 0) {
                        clearInterval(interval);
                        if (redirectUrl) window.location.href = redirectUrl;
                    }
                }, 1000);
            }
        }
        
        <?php if ($transaction['status'] === 'pending'): ?>
            // পেমেন্ট বাকি থাকলে এই জাভাস্ক্রিপ্টটি কাজ করবে
            const uniqueId = '<?php echo $transaction['unique_id'] ?? ''; ?>';
            const loader = document.querySelector('.bkash-loader');
            const selectionView = document.getElementById('selection-view');
            const instructionView = document.getElementById('instruction-view');
            const backButton = document.getElementById('back-to-selection');
            const verifyButton = document.getElementById('verifyButton');
            const transactionIdInput = document.getElementById('transaction_id');
            const amount = <?php echo json_encode(floatval($amount)); ?>;
            const initialToastMessage = <?php echo json_encode($toast_message); ?>;
            let selectedGatewayKey = null;

            function showToast(message, isSuccess) {
                const toast = document.getElementById('toast');
                if (toast) {
                    toast.innerText = message;
                    toast.style.backgroundColor = isSuccess ? '#28a745' : '#dc3545';
                    toast.classList.add('show');
                    setTimeout(() => toast.classList.remove('show'), 4000);
                }
            }
            if (initialToastMessage) { showToast(initialToastMessage, false); }
            
            document.querySelectorAll('.payment-method').forEach(method => {
                method.addEventListener('click', function() {
                    selectedGatewayKey = this.dataset.gatewayKey;
                    let action = null;
                    if (selectedGatewayKey === 'bkash_merchant_tokenized') action = 'initiate_tokenized_payment';
                    else if (selectedGatewayKey === 'nagad_merchant') action = 'initiate_nagad_payment';
                    else if (selectedGatewayKey === 'bkash_merchant_checkout') action = 'initiate_checkout_payment';

                    if (action) {
                        if (loader) loader.style.display = 'block';
                        fetch('api/verify_transaction.php', {
                            method: 'POST', headers: { 'Content-Type': 'application/json' },
                            body: JSON.stringify({ action: action, unique_payment_id: uniqueId, gateway_key: selectedGatewayKey })
                        }).then(res => res.json()).then(data => {
                            if (loader) loader.style.display = 'none';
                            if (data.success) {
                                if (data.redirect_url) { window.location.href = data.redirect_url; } 
                                else if (data.bkash_response && data.bkash_response.paymentID) {
                                    bKash.init({
                                        paymentMode: 'checkout',
                                        paymentRequest: { amount: amount.toString(), intent: 'sale', merchantInvoiceNumber: uniqueId },
                                        createRequest: (request) => bKash.create().onSuccess(data.bkash_response),
                                        executeRequestOnAuthorization: () => {
                                            if (loader) loader.style.display = 'block';
                                            fetch('api/verify_transaction.php', {
                                                method: 'POST', headers: {'Content-Type': 'application/json'},
                                                body: JSON.stringify({ action: 'execute_checkout_payment', paymentID: data.bkash_response.paymentID, unique_payment_id: uniqueId })
                                            }).then(res => res.json()).then(execData => {
                                                if (loader) loader.style.display = 'none';
                                                if (execData.success) { bKash.execute().onSuccess({}); window.location.reload(); } 
                                                else { showToast(execData.message || "Payment execution failed.", false); bKash.execute().onError(); }
                                            }).catch(() => {
                                                if (loader) loader.style.display = 'none';
                                                showToast("Network error during payment execution.", false); bKash.execute().onError();
                                            });
                                        },
                                        onClose: () => showToast("Payment was cancelled by user.", false)
                                    });
                                    document.getElementById('bKash_button').click();
                                }
                            } else { showToast(data.message || "Failed to initiate payment.", false); }
                        }).catch(() => { if (loader) loader.style.display = 'none'; showToast("A network error occurred.", false); });
                    } else {
                        document.getElementById('instruction-logo-main').src = this.dataset.logoSrc;
                        document.getElementById('instruction-amount').textContent = `${amount.toFixed(2)} BDT`;
                        document.getElementById('instruction-amount-text').textContent = `${amount.toFixed(2)}`;
                        document.getElementById('instruction-number').textContent = this.dataset.accountNumber;
                        document.getElementById('gateway-name-text').textContent = this.dataset.gatewayName.split(' ')[0];
                        if (selectionView) selectionView.style.display = 'none';
                        if (instructionView) instructionView.style.display = 'block';
                    }
                });
            });

            if (backButton) { backButton.addEventListener('click', () => { if (instructionView) instructionView.style.display = 'none'; if (selectionView) selectionView.style.display = 'block'; selectedGatewayKey = null; }); }
            if (verifyButton) {
                verifyButton.addEventListener('click', function() {
                    const trxId = transactionIdInput.value.trim();
                    if (trxId === '') { showToast("Please enter a Transaction ID.", false); return; }
                    this.disabled = true; this.innerText = 'VERIFYING...';
                    if (loader) loader.style.display = 'block';

                    fetch('api/verify_transaction.php', {
                        method: 'POST', headers: { 'Content-Type': 'application/json' },
                        body: JSON.stringify({ transaction_id: trxId, unique_payment_id: uniqueId, gateway_key: selectedGatewayKey })
                    }).then(res => res.json()).then(data => {
                        if (loader) loader.style.display = 'none';
                        if (data.success) { window.location.reload(); } 
                        else { showToast(data.message || "An error occurred during verification.", false); this.disabled = false; this.innerText = 'VERIFY PAYMENT'; }
                    }).catch(() => { if (loader) loader.style.display = 'none'; showToast("Request failed. Please check your network connection.", false); this.disabled = false; this.innerText = 'VERIFY PAYMENT'; });
                });
            }
            const payButton = document.querySelector('.new-btn-pay');
            if (payButton) { payButton.addEventListener('click', () => document.querySelector('.payment-method')?.click()); }
        <?php endif; ?>
    });
    </script>
    <button id="bKash_button" style="display:none;">Pay with bKash</button>
</body>
</html>