<?php
/**
 * Create Gateway Script for Web Dashboard
 * Version 2.1 - Handles authentication via PHP Session.
 * THIS FILE IS MEANT TO BE CALLED FROM THE WEB DASHBOARD FORM.
 */

// ব্যবহারকারী লগইন করা আছে কিনা তা কঠোরভাবে পরীক্ষা করা
// auth_check.php ফাইলটি session_start() কল করে এবং $_SESSION['user_id'] আছে কিনা তা নিশ্চিত করে।
require 'auth_check.php';

// যদি কোনো কারণে auth_check.php চালানোর পরেও সেশন না পাওয়া যায়, তবে স্ক্রিপ্ট বন্ধ করে দেওয়া হবে।
// এটি একটি অতিরিক্ত নিরাপত্তা স্তর।
if (!isset($_SESSION['user_id'])) {
    die("Authentication Error: User ID not found in session. Please log in again.");
}

// ডাটাবেস সংযোগ স্থাপন করা
require 'db_connect.php';

// শুধুমাত্র POST মেথডের অনুরোধ গ্রহণ করা হবে
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    // সেশন থেকে লগইন করা ব্যবহারকারীর আইডি (user_id) সংগ্রহ করা হচ্ছে।
    $user_id = $_SESSION['user_id']; 
    
    // ফর্ম থেকে পাঠানো গেটওয়ের কী (key) গ্রহণ করা হচ্ছে
    $gateway_key = $_POST['gateway_key'] ?? '';

    // গেটওয়ে কী-এর উপর ভিত্তি করে একটি ডিফল্ট নাম সেট করা
    $display_name = '';
    switch ($gateway_key) {
        case 'bkash_personal': $display_name = 'Bkash Personal'; break;
        case 'nagad_personal': $display_name = 'Nagad Personal'; break;
        case 'rocket_personal': $display_name = 'Rocket Personal'; break;
        case 'upay_personal': $display_name = 'Upay Personal'; break;
        case 'bkash_merchant_tokenized': $display_name = 'bKash Marchant (Tokenized)'; break;
        case 'nagad_merchant': $display_name = 'Nagad Marchant'; break;
        case 'bkash_merchant_checkout': $display_name = 'bKash Marchant (Checkout)'; break;
    }

    if (!empty($display_name)) {
        try {
            $sql = "INSERT INTO gateways (user_id, display_name, gateway_key) 
                    VALUES (:user_id, :display_name, :gateway_key)";
            
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                ':user_id' => $user_id,
                ':display_name' => $display_name,
                ':gateway_key' => $gateway_key
            ]);
        } catch (PDOException $e) {
            die("Database Error: Could not create the gateway. Details: " . $e->getMessage());
        }
    }
}

// সফলভাবে তৈরি হওয়ার পর বা কোনো ভুল অনুরোধ আসলে, ব্যবহারকারীকে পেমেন্ট গেটওয়ে পেজে ফিরিয়ে নেওয়া হবে
header("Location: payment.php");
exit();
?>