<?php
require 'auth_check.php';
require 'db_connect.php';

$file_name = $_GET['file'] ?? 'payment.php';
// ★★★ সমাধান: 'pay.php' এবং 'default.php' তালিকায় যুক্ত করা হয়েছে ★★★
$allowed_files = [
    'payment.php', 'payments.php', 'payment_links.php', 
    'create_payment_link.php', 'edit_payment_link.php',
    'pay.php', 'default.php'
];

if (!in_array($file_name, $allowed_files)) {
    die("Error: Editing this file is not permitted.");
}

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['content'])) {
    $content = $_POST['content'];
    
    $sql = "INSERT INTO file_templates (file_name, content) VALUES (:file_name, :content)
            ON DUPLICATE KEY UPDATE content = :content";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([':file_name' => $file_name, ':content' => $content]);
    $message = "Template '" . htmlspecialchars($file_name) . "' updated successfully!";
}

$stmt = $pdo->prepare("SELECT content FROM file_templates WHERE file_name = ?");
$stmt->execute([$file_name]);
$template = $stmt->fetch(PDO::FETCH_ASSOC);
$current_content = $template['content'] ?? '<!-- Enter the code for ' . htmlspecialchars($file_name) . ' here -->';

include 'templates/header.php';
include 'templates/sidebar.php';
?>
<div class="page-container">
    <div class="page-header">
        <h1 class="page-title">Edit File Template</h1>
    </div>
    
    <div style="margin-bottom: 20px; display: flex; flex-wrap: wrap; gap: 10px;">
        <a href="?file=payment.php" class="btn <?php echo $file_name === 'payment.php' ? 'btn-primary' : 'btn-secondary'; ?>">payment.php</a>
        <a href="?file=payments.php" class="btn <?php echo $file_name === 'payments.php' ? 'btn-primary' : 'btn-secondary'; ?>">payments.php</a>
        <a href="?file=payment_links.php" class="btn <?php echo $file_name === 'payment_links.php' ? 'btn-primary' : 'btn-secondary'; ?>">payment_links.php</a>
        <a href="?file=create_payment_link.php" class="btn <?php echo $file_name === 'create_payment_link.php' ? 'btn-primary' : 'btn-secondary'; ?>">create_payment_link.php</a>
        <a href="?file=edit_payment_link.php" class="btn <?php echo $file_name === 'edit_payment_link.php' ? 'btn-primary' : 'btn-secondary'; ?>">edit_payment_link.php</a>
        <!-- ★★★ সমাধান: নতুন দুটি বাটন যুক্ত করা হয়েছে ★★★ -->
        <a href="?file=pay.php" class="btn <?php echo $file_name === 'pay.php' ? 'btn-primary' : 'btn-secondary'; ?>">pay.php (Link)</a>
        <a href="?file=default.php" class="btn <?php echo $file_name === 'default.php' ? 'btn-primary' : 'btn-secondary'; ?>">default.php (Link)</a>
    </div>

    <?php if ($message): ?>
        <div style="padding: 10px; background-color: #d4edda; color: #155724; border-radius: 8px; margin-bottom: 20px;">
            <?php echo $message; ?>
        </div>
    <?php endif; ?>

    <div class="content-card">
        <form action="?file=<?php echo htmlspecialchars($file_name); ?>" method="POST">
            <div class="form-group">
                <label for="content">File Content for <strong><?php echo htmlspecialchars($file_name); ?></strong></label>
                <textarea name="content" id="content" rows="30" style="width: 100%; font-family: monospace; font-size: 14px;"><?php echo htmlspecialchars($current_content); ?></textarea>
            </div>
            <div class="form-actions">
                <button type="submit" class="btn btn-primary">Save Template</button>
            </div>
        </form>
    </div>
</div>
</div>
<script src="js/main.js?v=<?php echo @filemtime('js/main.js'); ?>"></script>
</body>
</html>