<?php
header('Content-Type: application/json');
require '../db_connect.php';

// API Key Authentication
$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';
if (empty($api_key)) { http_response_code(401); die(json_encode(['success' => false, 'message' => 'API Key is missing.'])); }
$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting = $stmt_user->fetch(PDO::FETCH_ASSOC);
if (!$setting) { http_response_code(403); die(json_encode(['success' => false, 'message' => 'Invalid API Key.'])); }

$user_id = $setting['user_id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $original_email = trim($_POST['original_email']);
    $name = trim($_POST['name']);
    $email = trim($_POST['email']);
    $phone = trim($_POST['phone']);
    $address = trim($_POST['address']) ?: null;
    $city = trim($_POST['city']) ?: null;
    $state = trim($_POST['state']) ?: null;
    $postcode = trim($_POST['postcode']) ?: null;
    $country = trim($_POST['country']) ?: null;

    if (empty($name) || empty($email) || empty($phone) || empty($original_email)) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Required fields are missing for update.']);
        exit();
    }
    
    try {
        $sql = "UPDATE transactions 
                SET customer_name = :name, customer_email = :email, phone = :phone, address = :address, 
                    city = :city, state = :state, postcode = :postcode, country = :country
                WHERE user_id = :user_id AND customer_email = :original_email";
        
        $stmt_update = $pdo->prepare($sql);
        $stmt_update->execute([
            ':name' => $name, ':email' => $email, ':phone' => $phone, ':address' => $address,
            ':city' => $city, ':state' => $state, ':postcode' => $postcode, ':country' => $country,
            ':user_id' => $user_id, ':original_email' => $original_email
        ]);

        if ($stmt_update->rowCount() > 0) {
            echo json_encode(['success' => true, 'message' => 'Customer updated successfully.']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Customer not found or no changes made.']);
        }

    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
    }
}
?>