<?php
header('Content-Type: application/json');
require '../db_connect.php';

// হেডার থেকে API Key নেওয়া হচ্ছে (X-API-KEY)
$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';

if (empty($api_key)) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'API Key is missing.']);
    exit();
}

// API Key দিয়ে user_id খুঁজে বের করা হচ্ছে
$stmt = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt->execute([$api_key]);
$setting = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$setting) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Invalid API Key.']);
    exit();
}

$user_id = $setting['user_id'];

// অ্যাপ থেকে পাঠানো JSON ডেটা পড়া হচ্ছে
$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

// প্রয়োজনীয় তথ্য ভ্যারিয়েবলে রাখা হচ্ছে
$device_uid = $data['device_uid'] ?? null; // Secure Android ID
$device_name = $data['device_name'] ?? 'Unknown';
$device_model = $data['device_model'] ?? 'Unknown';
$android_version = $data['android_version'] ?? 'Unknown';
$app_version = $data['app_version'] ?? 'Unknown';

if (!$device_uid) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Device UID is required.']);
    exit();
}

// ডেটাবেসে ডিভাইস রেজিস্টার বা আপডেট করা হচ্ছে
// ON DUPLICATE KEY UPDATE ব্যবহার করায় একই ডিভাইস বারবার রেজিস্টার হবে না, শুধু আপডেট হবে
$sql = "INSERT INTO devices (user_id, device_id, device_name, device_model, android_version, app_version, status) 
        VALUES (:user_id, :device_id, :device_name, :device_model, :android_version, :app_version, 'CONNECTED')
        ON DUPLICATE KEY UPDATE 
        user_id = :user_id, device_name = :device_name, device_model = :device_model, 
        android_version = :android_version, app_version = :app_version, status = 'CONNECTED'";

try {
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'user_id' => $user_id,
        'device_id' => $device_uid,
        'device_name' => $device_name,
        'device_model' => $device_model,
        'android_version' => $android_version,
        'app_version' => $app_version
    ]);

    echo json_encode(['success' => true, 'message' => 'Device registered successfully.']);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error on device registration.', 'error' => $e->getMessage()]);
}