<?php
require 'auth_check.php';
require 'db_connect.php';

$gateway_id = $_GET['id'] ?? null;
$user_id = $_SESSION['user_id'];

if (!$gateway_id) {
    header("Location: payment.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stmt_check = $pdo->prepare("SELECT gateway_key FROM gateways WHERE id = ? AND user_id = ?");
    $stmt_check->execute([$gateway_id, $user_id]);
    $gateway_check = $stmt_check->fetch(PDO::FETCH_ASSOC);

    if ($gateway_check) {
        $key = $gateway_check['gateway_key'];
        // test_mode এর ভ্যালু POST রিকোয়েস্ট থেকে নেওয়া হচ্ছে (চেকবক্স সিলেক্ট করা থাকলে 1, না থাকলে 0)
        $test_mode = isset($_POST['test_mode']) ? 1 : 0;
        
        if ($key === 'bkash_merchant_tokenized' || $key === 'bkash_merchant_checkout') {
            // bKash গেটওয়ের জন্য test_mode সহ সকল ডেটা আপডেট করা হচ্ছে
            $sql = "UPDATE gateways SET display_name = :d_name, min_amount = :min_a, max_amount = :max_a, fixed_charge = :f_charge, percentage_charge = :p_charge, app_key = :app_k, app_secret = :app_s, username = :uname, password = :pass, test_mode = :test_mode WHERE id = :id AND user_id = :uid";
            $params = [
                'd_name' => $_POST['display_name'], 'min_a' => $_POST['min_amount'] ?: null, 'max_a' => $_POST['max_amount'] ?: null, 'f_charge' => $_POST['fixed_charge'] ?: null, 'p_charge' => $_POST['percentage_charge'] ?: null,
                'app_k' => trim($_POST['app_key']), 'app_s' => trim($_POST['app_secret']), 'uname' => trim($_POST['username']), 'pass' => trim($_POST['password']), 'test_mode' => $test_mode, 'id' => $gateway_id, 'uid' => $user_id
            ];
        } elseif ($key === 'nagad_merchant') {
            // Nagad গেটওয়ের জন্য test_mode সহ সকল ডেটা আপডেট করা হচ্ছে
            $sql = "UPDATE gateways SET display_name = :d_name, min_amount = :min_a, max_amount = :max_a, fixed_charge = :f_charge, percentage_charge = :p_charge, merchant_id = :m_id, merchant_private_key = :m_pk, nagad_public_key = :n_pk, test_mode = :test_mode WHERE id = :id AND user_id = :uid";
            $params = [
                'd_name' => $_POST['display_name'], 'min_a' => $_POST['min_amount'] ?: null, 'max_a' => $_POST['max_amount'] ?: null, 'f_charge' => $_POST['fixed_charge'] ?: null, 'p_charge' => $_POST['percentage_charge'] ?: null,
                'm_id' => trim($_POST['merchant_id']), 'm_pk' => trim($_POST['merchant_private_key']), 'n_pk' => trim($_POST['nagad_public_key']), 'test_mode' => $test_mode, 'id' => $gateway_id, 'uid' => $user_id
            ];
        } else {
            // অন্যান্য (Send Money) গেটওয়ের জন্য ডেটা আপডেট করা হচ্ছে
            $sql = "UPDATE gateways SET display_name = :d_name, min_amount = :min_a, max_amount = :max_a, fixed_charge = :f_charge, percentage_charge = :p_charge, account_number = :acc_num WHERE id = :id AND user_id = :uid";
            $params = [
                'd_name' => $_POST['display_name'], 'min_a' => $_POST['min_amount'], 'max_a' => $_POST['max_amount'], 'f_charge' => $_POST['fixed_charge'], 'p_charge' => $_POST['percentage_charge'],
                'acc_num' => $_POST['account_number'], 'id' => $gateway_id, 'uid' => $user_id
            ];
        }
        $stmt = $pdo->prepare($sql);
        $stmt->execute($params);
    }
    header("Location: payment.php");
    exit();
}

$stmt = $pdo->prepare("SELECT * FROM gateways WHERE id = ? AND user_id = ?");
$stmt->execute([$gateway_id, $user_id]);
$gateway = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$gateway) {
    header("Location: payment.php");
    exit();
}

$is_tokenized = ($gateway['gateway_key'] === 'bkash_merchant_tokenized');
$is_checkout_popup = ($gateway['gateway_key'] === 'bkash_merchant_checkout');
$is_nagad = ($gateway['gateway_key'] === 'nagad_merchant');

include 'templates/header.php';
include 'templates/sidebar.php';
?>

<div class="page-container">
    <div class="page-header">
        <div>
            <p class="breadcrumbs">Gateways > Edit</p>
            <h1 class="page-title">Edit Gateway: <?php echo htmlspecialchars($gateway['display_name']); ?></h1>
        </div>
    </div>

    <div class="content-card">
        <form action="edit_gateway.php?id=<?php echo $gateway['id']; ?>" method="POST">
            <?php if ($is_tokenized || $is_checkout_popup): ?>
                <!-- bKash মার্চেন্ট গেটওয়ের জন্য UI -->
                <div class="settings-section" style="border-top: none; padding-top: 5px;">
                    <h3>General & Charges</h3>
                    <p>Configure the general settings and transaction charges.</p>
                    <div class="form-grid">
                        <div class="form-group"><label for="display_name">Display Name</label><input type="text" id="display_name" name="display_name" value="<?php echo htmlspecialchars($gateway['display_name']); ?>"></div>
                        <div class="form-group"></div>
                        <div class="form-group"><label for="min_amount">Minimum Amount</label><input type="number" step="0.01" id="min_amount" name="min_amount" value="<?php echo htmlspecialchars($gateway['min_amount']); ?>"></div>
                        <div class="form-group"><label for="max_amount">Maximum Amount</label><input type="number" step="0.01" id="max_amount" name="max_amount" value="<?php echo htmlspecialchars($gateway['max_amount']); ?>"></div>
                        <div class="form-group"><label for="fixed_charge">Fixed Charge</label><input type="number" step="0.01" id="fixed_charge" name="fixed_charge" value="<?php echo htmlspecialchars($gateway['fixed_charge']); ?>"></div>
                        <div class="form-group"><label for="percentage_charge">Percentage Charge (%)</label><input type="number" step="0.01" id="percentage_charge" name="percentage_charge" value="<?php echo htmlspecialchars($gateway['percentage_charge']); ?>"></div>
                    </div>
                </div>
                <div class="settings-section">
                    <h3>Environment</h3>
                    <p>Enable test mode to use the bKash sandbox environment for this gateway.</p>
                    <div class="form-group">
                        <label>Test Mode</label>
                        <label class="toggle-switch">
                            <input type="checkbox" name="test_mode" value="1" <?php echo ($gateway['test_mode'] ?? 0) ? 'checked' : ''; ?>>
                            <span class="slider"></span>
                        </label>
                        <small>When enabled, all transactions for this gateway will be processed through the sandbox.</small>
                    </div>
                </div>
                <div class="settings-section">
                     <h3>API Credentials</h3>
                     <p>Enter your bKash merchant API credentials below. Provide sandbox keys if Test Mode is enabled.</p>
                     <div class="form-group"><label for="app_key">App Key</label><input type="text" id="app_key" name="app_key" value="<?php echo htmlspecialchars($gateway['app_key'] ?? ''); ?>"></div>
                     <div class="form-group"><label for="app_secret">App Secret</label><input type="text" id="app_secret" name="app_secret" value="<?php echo htmlspecialchars($gateway['app_secret'] ?? ''); ?>"></div>
                     <div class="form-group"><label for="username">Username</label><input type="text" id="username" name="username" value="<?php echo htmlspecialchars($gateway['username'] ?? ''); ?>"></div>
                     <div class="form-group"><label for="password">Password</label><input type="password" id="password" name="password" value="<?php echo htmlspecialchars($gateway['password'] ?? ''); ?>"></div>
                </div>

            <?php elseif ($is_nagad): ?>
                <!-- Nagad মার্চেন্ট গেটওয়ের জন্য UI -->
                <div class="settings-section" style="border-top: none; padding-top: 5px;">
                    <h3>General & Charges</h3>
                    <p>Configure the general settings and transaction charges for Nagad.</p>
                    <div class="form-grid">
                        <div class="form-group"><label for="display_name">Display Name</label><input type="text" id="display_name" name="display_name" value="<?php echo htmlspecialchars($gateway['display_name']); ?>"></div>
                        <div class="form-group"></div>
                        <div class="form-group"><label for="min_amount">Minimum Amount</label><input type="number" step="0.01" id="min_amount" name="min_amount" value="<?php echo htmlspecialchars($gateway['min_amount']); ?>"></div>
                        <div class="form-group"><label for="max_amount">Maximum Amount</label><input type="number" step="0.01" id="max_amount" name="max_amount" value="<?php echo htmlspecialchars($gateway['max_amount']); ?>"></div>
                        <div class="form-group"><label for="fixed_charge">Fixed Charge</label><input type="number" step="0.01" id="fixed_charge" name="fixed_charge" value="<?php echo htmlspecialchars($gateway['fixed_charge']); ?>"></div>
                        <div class="form-group"><label for="percentage_charge">Percentage Charge (%)</label><input type="number" step="0.01" id="percentage_charge" name="percentage_charge" value="<?php echo htmlspecialchars($gateway['percentage_charge']); ?>"></div>
                    </div>
                </div>
                <div class="settings-section">
                    <h3>Environment</h3>
                    <p>Enable test mode to use the Nagad sandbox environment for this gateway.</p>
                    <div class="form-group">
                        <label>Test Mode</label>
                        <label class="toggle-switch">
                            <input type="checkbox" name="test_mode" value="1" <?php echo ($gateway['test_mode'] ?? 0) ? 'checked' : ''; ?>>
                            <span class="slider"></span>
                        </label>
                        <small>When enabled, all transactions for this gateway will be processed through the sandbox.</small>
                    </div>
                </div>
                <div class="settings-section">
                     <h3>API Credentials</h3>
                     <p>Enter your Nagad merchant API credentials below. Provide sandbox keys if Test Mode is enabled.</p>
                     <div class="form-group"><label for="merchant_id">Merchant ID</label><input type="text" id="merchant_id" name="merchant_id" value="<?php echo htmlspecialchars($gateway['merchant_id'] ?? ''); ?>"></div>
                     <div class="form-group"><label for="merchant_private_key">Merchant Private Key</label><textarea id="merchant_private_key" name="merchant_private_key" rows="6"><?php echo htmlspecialchars($gateway['merchant_private_key'] ?? ''); ?></textarea></div>
                     <div class="form-group"><label for="nagad_public_key">Nagad Gateway Public Key</label><textarea id="nagad_public_key" name="nagad_public_key" rows="6"><?php echo htmlspecialchars($gateway['nagad_public_key'] ?? ''); ?></textarea></div>
                </div>

            <?php else: ?>
                <!-- অন্যান্য Send Money গেটওয়ের জন্য UI -->
                <div class="settings-section">
                    <h3>General Settings</h3>
                    <div class="form-grid">
                        <div class="form-group"><label for="display_name">Display Name</label><input type="text" id="display_name" name="display_name" value="<?php echo htmlspecialchars($gateway['display_name']); ?>"></div>
                        <div class="form-group"><label for="account_number">Account Number</label><input type="text" id="account_number" name="account_number" value="<?php echo htmlspecialchars($gateway['account_number']); ?>"></div>
                    </div>
                </div>
            <?php endif; ?>

            <div class="form-actions"><button type="submit" class="btn btn-primary">Save Changes</button><a href="payment.php" class="btn btn-secondary">Cancel</a></div>
        </form>
    </div>
</div>
</div>
<script src="js/main.js?v=<?php echo filemtime('js/main.js'); ?>"></script>
</body>
</html>