<?php
// PHP-কে বেশি সময় ধরে চলার এবং বেশি মেমরি ব্যবহারের অনুমতি দেওয়া হচ্ছে
@set_time_limit(300);
@ini_set('memory_limit', '256M');

// এই স্ক্রিপ্টটি শুধুমাত্র কমান্ড লাইন (Cron Job) থেকে চালানো যাবে
if (php_sapi_name() !== 'cli' && substr(php_sapi_name(), 0, 3) !== 'cgi') {
    die("This script can only be run from the command line (Cron Job).");
}

// মূল কনফিগারেশন ফাইল লোড করা
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/db_connect.php';

// কনস্ট্যান্ট বা ধ্রুবক নির্ধারণ
define('CENTRAL_API_URL', 'https://settings.top/dashboard_project/api/check_update.php'); // আপনার কেন্দ্রীয় সার্ভারের URL
define('UPDATE_LOG_FILE', __DIR__ . '/update_log.txt');
define('MAINTENANCE_FLAG', __DIR__ . '/maintenance.flag');

// লগ মেসেজ লেখার জন্য ফাংশন
function log_message($message) {
    file_put_contents(UPDATE_LOG_FILE, date('[Y-m-d H:i:s] ') . $message . "\n", FILE_APPEND);
}

log_message("--- Starting Update Check (Current Version: " . APP_VERSION . ") ---");

try {
    // ধাপ ১: কেন্দ্রীয় সার্ভারে আপডেটের জন্য চেক করা
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, CENTRAL_API_URL);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
        'license_key' => LICENSE_KEY,
        'current_version' => APP_VERSION
    ]));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);
    $update_info = json_decode($response, true);

    if (!$update_info || !isset($update_info['update_available'])) {
        throw new Exception("Invalid response from update server: " . $response);
    }

    // ধাপ ২: যদি নতুন আপডেট পাওয়া যায়
    if ($update_info['update_available']) {
        log_message("Update found! New version: " . $update_info['version']);

        // রক্ষণাবেক্ষণ মোড (Maintenance Mode) চালু করা
        file_put_contents(MAINTENANCE_FLAG, 'Application is currently being updated.');
        log_message("Maintenance mode enabled.");

        // ধাপ ৩: আপডেট ফাইল ডাউনলোড করা
        $zip_file_path = __DIR__ . '/update_package.zip';
        $downloaded_data = file_get_contents($update_info['download_url']);
        if ($downloaded_data === false) {
            throw new Exception("Failed to download update file from " . $update_info['download_url']);
        }
        file_put_contents($zip_file_path, $downloaded_data);
        log_message("Update package downloaded successfully.");

        // ধাপ ৪: জিপ ফাইল আনজিপ এবং ফাইল প্রতিস্থাপন করা
        $zip = new ZipArchive;
        if ($zip->open($zip_file_path) === TRUE) {
            $zip->extractTo(__DIR__ . '/');
            $zip->close();
            log_message("Files extracted and updated successfully.");
        } else {
            throw new Exception("Failed to open the downloaded ZIP file.");
        }
        unlink($zip_file_path);

        // ধাপ ৫: ডাটাবেস মাইগ্রেশন চালানো (যদি থাকে)
        if (!empty($update_info['sql_migration'])) {
            log_message("Running database migration...");
            $pdo->exec($update_info['sql_migration']);
            log_message("Database migration completed.");
        }

        // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        // ★★★    config.php ফাইলে ভার্সন নম্বর অটো-আপডেট     ★★★
        // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        $config_path = __DIR__ . '/config.php';
        $config_content = file_get_contents($config_path);
        
        // পুরোনো ভার্সন লাইনটি খুঁজে নতুন লাইন দিয়ে প্রতিস্থাপন করা হচ্ছে
        $new_config_content = preg_replace(
            "/define\s*\(\s*'APP_VERSION'\s*,\s*'.*?'\s*\);/", // পুরোনো ভার্সন খুঁজে বের করার রেগুলার এক্সপ্রেশন
            "define('APP_VERSION', '" . $update_info['version'] . "');", // নতুন ভার্সন দিয়ে প্রতিস্থাপন
            $config_content
        );

        if ($new_config_content === null || $new_config_content === $config_content) {
            log_message("WARNING: Could not automatically update APP_VERSION in config.php. Please update it manually.");
        } else {
            file_put_contents($config_path, $new_config_content);
            log_message("Config file updated to version " . $update_info['version']);
        }
        // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★

        // রক্ষণাবেক্ষণ মোড বন্ধ করা
        if (file_exists(MAINTENANCE_FLAG)) {
            unlink(MAINTENANCE_FLAG);
        }
        log_message("Maintenance mode disabled. Update process finished successfully.");

    } else {
        log_message("No new updates found. Application is up-to-date.");
    }

} catch (Exception $e) {
    log_message("!!! UPDATE FAILED: " . $e->getMessage());
    // এরর হলেও রক্ষণাবেক্ষণ মোড বন্ধ করা
    if (file_exists(MAINTENANCE_FLAG)) {
        unlink(MAINTENANCE_FLAG);
    }
}

echo "Update check finished. Check log file for details.";