<?php
require 'auth_check.php';
include 'templates/header.php';
include 'templates/sidebar.php';

// PHP-র সঠিক পাথ খুঁজে বের করার চেষ্টা
$php_path = 'php'; // ডিফল্ট
if (defined('PHP_BINARY') && is_executable(PHP_BINARY)) {
    $php_path = PHP_BINARY;
}

$script_path = __DIR__ . '/run_updater.php';
// Cron Job কমান্ড তৈরি
$cron_command = "{$php_path} -q {$script_path} >/dev/null 2>&1";
?>
<div class="page-container">
    <div class="page-header">
        <h1 class="page-title">Application Updater</h1>
    </div>

    <div class="content-card">
        <h3>Automatic Updates Setup</h3>
        <p>To enable automatic updates, you need to set up a Cron Job on your server's control panel (e.g., cPanel).</p>
        
        <div class="form-group">
            <label>Cron Command</label>
            <p>Copy the following command and add it as a new cron job. It is recommended to run it once every 24 hours.</p>
            <pre><code><?php echo htmlspecialchars($cron_command); ?></code></pre>
        </div>

        <h4>How to set up in cPanel:</h4>
        <ol>
            <li>Log in to your cPanel.</li>
            <li>Find and click on the "Cron Jobs" icon in the "Advanced" section.</li>
            <li>Under "Add New Cron Job", select "Once a Day" from the "Common Settings" dropdown.</li>
            <li>Paste the command above into the "Command" field.</li>
            <li>Click "Add New Cron Job".</li>
        </ol>
    </div>
</div>
<?php include 'templates/footer.php'; ?>