<?php
header('Content-Type: application/json');
require '../db_connect.php';

// API Key দিয়ে অথেন্টিকেশন
$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';
if (empty($api_key)) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'API Key is missing.']);
    exit();
}

$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting = $stmt_user->fetch(PDO::FETCH_ASSOC);

if (!$setting) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Invalid API Key.']);
    exit();
}
$user_id = $setting['user_id'];
$sms_id = $_POST['id'] ?? null;

if (!$sms_id) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'SMS Record ID is required.']);
    exit();
}

try {
    // is_trashed ফ্ল্যাগটি 1-এ সেট করা হচ্ছে
    $sql = "UPDATE sms_transactions SET is_trashed = 1 WHERE id = :id AND user_id = :user_id";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([':id' => $sms_id, ':user_id' => $user_id]);

    if ($stmt->rowCount() > 0) {
        echo json_encode(['success' => true, 'message' => 'Record moved to trash.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Record not found or permission denied.']);
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error.']);
}
?>