<?php
require 'auth_check.php';
require 'db_connect.php';

$email = $_GET['email'] ?? null;
$user_id = $_SESSION['user_id'];

if ($email && $user_id) {
    try {
        $sql = "DELETE FROM transactions WHERE user_id = :user_id AND customer_email = :email";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([':user_id' => $user_id, ':email' => $email]);
    } catch (PDOException $e) {
        error_log("Error deleting customer: " . $e->getMessage());
        header("Location: customers.php?error=delete_failed");
        exit();
    }
}

header("Location: customers.php?success=deleted");
exit();
