<?php
header('Content-Type: application/json');
require 'auth_check.php';
require 'db_connect.php';

$user_id = $_SESSION['user_id'];
$response = ['success' => false, 'message' => ''];

try {
    // ব্যবহারকারীর জন্য ডিফল্ট লিঙ্ক আছে কিনা তা খোঁজা হচ্ছে
    $stmt = $pdo->prepare("SELECT unique_link_id FROM payment_links WHERE user_id = ? AND is_default = 1 LIMIT 1");
    $stmt->execute([$user_id]);
    $link = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($link && !empty($link['unique_link_id'])) {
        $unique_id = $link['unique_link_id'];
    } else {
        // যদি না থাকে, তবে একটি নতুন ডিফল্ট লিঙ্ক তৈরি করা হচ্ছে
        $unique_id = 'default-' . bin2hex(random_bytes(12));
        
        $insert_stmt = $pdo->prepare(
            "INSERT INTO payment_links (user_id, product_name, unique_link_id, is_default, status) 
             VALUES (?, 'Default Payment Link', ?, 1, 1)"
        );
        $insert_stmt->execute([$user_id, $unique_id]);
    }
    
    $response['success'] = true;
    $response['unique_id'] = $unique_id;

} catch (PDOException $e) {
    $response['message'] = 'Database error: ' . $e->getMessage();
}

echo json_encode($response);
?>