<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');
require '../db_connect.php'; // ডেটাবেস সংযোগ

// ★★★ পরিবর্তন এখানে: $_POST থেকে সরাসরি ডেটা নেওয়া হচ্ছে ★★★
$email = $_POST['email'] ?? '';
$password = $_POST['password'] ?? '';

if (empty($email) || empty($password)) {
    http_response_code(400); // Bad Request
    echo json_encode(['success' => false, 'message' => 'Email and password are required.']);
    exit();
}

try {
    // ব্যবহারকারীকে ইমেইল দিয়ে খোঁজা হচ্ছে
    $stmt = $pdo->prepare("SELECT id, username, password FROM users WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    // পাসওয়ার্ড যাচাই করা হচ্ছে
    if ($user && password_verify($password, $user['password'])) {
        // পাসওয়ার্ড সঠিক হলে, settings টেবিল থেকে api_key আনা হচ্ছে
        $stmt_key = $pdo->prepare("SELECT api_key FROM settings WHERE user_id = ?");
        $stmt_key->execute([$user['id']]);
        $setting = $stmt_key->fetch(PDO::FETCH_ASSOC);

        if ($setting && !empty($setting['api_key'])) {
            // সফলভাবে লগইন হলে প্রয়োজনীয় তথ্য পাঠানো হচ্ছে
            echo json_encode([
                'success' => true,
                'message' => 'Login successful',
                'user_id' => $user['id'],
                'name' => $user['username'],
                'api_key' => $setting['api_key']
            ]);
        } else {
            http_response_code(403); // Forbidden
            echo json_encode(['success' => false, 'message' => 'API key not found for this user.']);
        }
    } else {
        // ইমেইল বা পাসওয়ার্ড ভুল হলে
        http_response_code(401); // Unauthorized
        echo json_encode(['success' => false, 'message' => 'Invalid email or password.']);
    }

} catch (PDOException $e) {
    http_response_code(500); // Internal Server Error
    echo json_encode(['success' => false, 'message' => 'Database error.']);
}