<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');
require '../db_connect.php';

$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

$email = $data['email'] ?? '';
$token = $data['token'] ?? '';

if (empty($email) || empty($token)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Email and token are required.']);
    exit();
}

try {
    // ইমেইল দিয়ে ব্যবহারকারীকে খোঁজা হচ্ছে এবং টোকেন মেলানো হচ্ছে
    $stmt = $pdo->prepare("SELECT id, username FROM users WHERE email = ? AND app_auth_token = ?");
    $stmt->execute([$email, $token]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user) {
        // টোকেন সঠিক হলে, এটিকে একবার ব্যবহারের পর নষ্ট করে দেওয়া হচ্ছে (নিরাপত্তার জন্য)
        $stmt_invalidate = $pdo->prepare("UPDATE users SET app_auth_token = NULL WHERE id = ?");
        $stmt_invalidate->execute([$user['id']]);

        // settings টেবিল থেকে api_key আনা হচ্ছে
        $stmt_key = $pdo->prepare("SELECT api_key FROM settings WHERE user_id = ?");
        $stmt_key->execute([$user['id']]);
        $setting = $stmt_key->fetch(PDO::FETCH_ASSOC);

        if ($setting && !empty($setting['api_key'])) {
            // সফল হলে প্রয়োজনীয় তথ্য পাঠানো হচ্ছে
            echo json_encode([
                'success' => true,
                'message' => 'Login successful',
                'user_id' => $user['id'],
                'name' => $user['username'],
                'api_key' => $setting['api_key']
            ]);
        } else {
            http_response_code(403);
            echo json_encode(['success' => false, 'message' => 'API key not found for this user.']);
        }
    } else {
        // টোকেন ভুল বা ব্যবহারকারী খুঁজে না পাওয়া গেলে
        http_response_code(401);
        echo json_encode(['success' => false, 'message' => 'Invalid or expired QR token.']);
    }

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error.']);
}