<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Database Setup - Setup Wizard</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="container">
        <h1>Step 3: Database Setup</h1>
        <p>Please provide your database connection details. Make sure the database is already created on your server.</p>

        <?php if (isset($_SESSION['message'])): ?>
            <div class="message <?php echo $_SESSION['message']['type']; ?>">
                <?php echo htmlspecialchars($_SESSION['message']['text']); unset($_SESSION['message']); ?>
            </div>
        <?php endif; ?>

        <form action="index.php?step=database" method="POST">
            <input type="hidden" name="action" value="setup_database">
            <div class="form-group">
                <label for="db_host">Database Host</label>
                <input type="text" id="db_host" name="db_host" value="localhost" required>
            </div>
            <div class="form-group">
                <label for="db_name">Database Name</label>
                <input type="text" id="db_name" name="db_name" required placeholder="e.g., myapp_db">
            </div>
            <div class="form-group">
                <label for="db_user">Database Username</label>
                <input type="text" id="db_user" name="db_user" required placeholder="e.g., myapp_user">
            </div>
            <div class="form-group">
                <label for="db_pass">Database Password</label>
                <input type="password" id="db_pass" name="db_pass">
            </div>
            <button type="submit" class="button">Setup Database & Continue</button>
        </form>
    </div>
</body>
</html>