<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>License Verification - Setup Wizard</title>
    <link rel="stylesheet" href="style.css?v=<?php echo filemtime('style.css'); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>
    <div class="container">
        <h1>Step 2: License Verification</h1>
        <p>Please enter the license key you received after your purchase to proceed with the installation.</p>

        <?php if (isset($_SESSION['message'])): ?>
            <div class="message <?php echo $_SESSION['message']['type']; ?>">
                <?php echo htmlspecialchars($_SESSION['message']['text']); unset($_SESSION['message']); ?>
            </div>
        <?php endif; ?>

        <!-- ★★★ আপনার ডিজাইন অনুযায়ী নতুন লাইসেন্স ফর্ম ★★★ -->
        <form action="index.php?step=license" method="POST" id="license-form">
            <input type="hidden" name="action" value="verify_license">
            <!-- এই হিডেন ফিল্ডটিতে জাভাস্ক্রিপ্ট দিয়ে সম্পূর্ণ লাইসেন্স কী একত্রিত করে রাখা হবে -->
            <input type="hidden" id="license_key_full" name="license_key">
            
            <div class="form-group">
                <label for="license_part_1">License Key</label>
                <div class="license-input-group">
                    <input type="text" id="license_part_1" class="license-part" maxlength="5" data-next="license_part_2">
                    <span class="hyphen">-</span>
                    <input type="text" id="license_part_2" class="license-part" maxlength="5" data-next="license_part_3">
                    <span class="hyphen">-</span>
                    <input type="text" id="license_part_3" class="license-part" maxlength="5" data-next="license_part_4">
                    <span class="hyphen">-</span>
                    <input type="text" id="license_part_4" class="license-part" maxlength="5" data-next="license_part_5">
                    <span class="hyphen">-</span>
                    <input type="text" id="license_part_5" class="license-part" maxlength="3">
                </div>
            </div>
            <button type="submit" class="button">Verify & Continue</button>
        </form>
    </div>

    <!-- ★★★ নতুন জাভাস্ক্রিপ্ট কোড ★★★ -->
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.getElementById('license-form');
        const parts = Array.from(document.querySelectorAll('.license-part'));
        const fullLicenseKeyInput = document.getElementById('license_key_full');

        parts.forEach(input => {
            // ইনপুট ফিল্ডে কিছু লিখলে স্বয়ংক্রিয়ভাবে বড় হাতের অক্ষরে পরিণত হবে
            input.addEventListener('input', (e) => {
                e.target.value = e.target.value.toUpperCase();
                
                // যদি বক্সটি পূর্ণ হয়ে যায়, তাহলে স্বয়ংক্রিয়ভাবে পরের বক্সে কার্সর চলে যাবে
                const nextFieldId = e.target.dataset.next;
                if (e.target.value.length === e.target.maxLength && nextFieldId) {
                    document.getElementById(nextFieldId).focus();
                }
            });

            // Backspace চাপলে আগের বক্সে কার্সর ফিরিয়ে আনার জন্য
            input.addEventListener('keydown', (e) => {
                if (e.key === 'Backspace' && e.target.value.length === 0) {
                    const prev = parts[parts.indexOf(e.target) - 1];
                    if (prev) {
                        prev.focus();
                    }
                }
            });
        });

        // ফর্ম সাবমিট করার ঠিক আগে, সবগুলো বক্সের মান একত্রিত করে হিডেন ফিল্ডে রাখা হবে
        form.addEventListener('submit', (e) => {
            const licenseKey = parts.map(input => input.value).join('-');
            fullLicenseKeyInput.value = licenseKey;
        });
    });
    </script>
</body>
</html>