<?php
// dashboard_project/paymentlink/default.php

require '../db_connect.php';

// URL থেকে ব্যবহারকারীর আইডি নেওয়া হচ্ছে। এটি ছাড়া সিস্টেম বুঝবে না কার গেটওয়ে ব্যবহার করতে হবে।
$user_id = $_GET['account'] ?? null;
if (!$user_id) {
    die("Invalid or incomplete payment link. Account identifier is missing.");
}

// ব্যবহারকারীর অস্তিত্ব যাচাই করা
$stmt_user = $pdo->prepare("SELECT id FROM users WHERE id = ?");
$stmt_user->execute([$user_id]);
if ($stmt_user->rowCount() === 0) {
    die("The account associated with this link does not exist.");
}

// ফর্ম সাবমিট হলে এই অংশটি কাজ করবে
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $customer_name = trim($_POST['full_name']);
    $customer_email = trim($_POST['email']);
    $customer_mobile = trim($_POST['mobile_number']);
    $amount = (float)($_POST['amount']);
    $reference = trim($_POST['reference']) ?: null;

    // প্রয়োজনীয় তথ্য যাচাই
    if (empty($customer_name) || empty($customer_email) || empty($customer_mobile) || $amount <= 0) {
        die("Please fill all required fields correctly.");
    }

    try {
        // নতুন ট্রানজেকশন আইডি তৈরি
        $transaction_unique_id = sha1(uniqid(rand(), true) . microtime());
        
        // বেস URL তৈরি করা
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https" : "http";
        $host = $_SERVER['HTTP_HOST'];
        $directory = rtrim(dirname(dirname($_SERVER['PHP_SELF'])), '/\\');
        $base_project_url = "{$protocol}://{$host}{$directory}";
        
        $cancel_url = "{$base_project_url}/checkout.php?trx_id={$transaction_unique_id}&status=cancelled";

        $sql = "INSERT INTO transactions (user_id, unique_id, amount, customer_name, customer_email, success_url, cancel_url, meta_data) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        
        $stmt_insert = $pdo->prepare($sql);
        $stmt_insert->execute([
            $user_id,
            $transaction_unique_id,
            $amount,
            $customer_name,
            $customer_email,
            $base_project_url . '/index.php', // সফল হলে ড্যাশবোর্ডে পাঠানো যেতে পারে
            $cancel_url,
            json_encode([
                'source' => 'default_payment_link',
                'reference' => $reference,
                'customer_mobile' => $customer_mobile // মোবাইল নম্বর meta_data তে সেভ করা হচ্ছে
            ])
        ]);

        // চেকআউট পেজে রিডাইরেক্ট করা হচ্ছে
        header("Location: ../checkout.php?trx_id=" . $transaction_unique_id);
        exit();

    } catch (PDOException $e) {
        die("Could not initiate payment session: " . $e->getMessage());
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Complete Your Payment</title>
    <?php
        // ডাইনামিকভাবে বেস URL তৈরি করা হচ্ছে, যাতে CSS সঠিকভাবে লোড হয়
        $base_project_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]" . rtrim(dirname(dirname($_SERVER['PHP_SELF'])), '/\\');
    ?>
    <link rel="stylesheet" href="<?php echo $base_project_url; ?>/css/style.css?v=<?php echo filemtime('../css/style.css'); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="default-link-body">
    <div class="default-link-container">
        <!-- বাম পাশের প্যানেল -->
        <div class="left-panel">
            <img src="<?php echo $base_project_url; ?>/images/logo.png" alt="Company Logo" class="company-logo">
            <img src="<?php echo $base_project_url; ?>/images/customer-attraction.png" alt="Illustration" class="illustration-img">
        </div>

        <!-- ডান পাশের প্যানেল (ফর্ম) -->
        <div class="right-panel">
            <form action="default.php?account=<?php echo htmlspecialchars($user_id); ?>" method="POST">
                <div class="form-input-group">
                    <i class="fas fa-user"></i>
                    <input type="text" name="full_name" placeholder="Full Name" required>
                </div>
                <div class="form-input-group">
                    <i class="fas fa-envelope"></i>
                    <input type="email" name="email" placeholder="Email" required>
                </div>
                <div class="form-input-group">
                    <i class="fas fa-phone"></i>
                    <input type="text" name="mobile_number" placeholder="Mobile Number" required>
                </div>
                <div class="form-input-group">
                    <i class="fas fa-dollar-sign"></i>
                    <input type="number" step="0.01" name="amount" placeholder="Amount" required>
                </div>
                <div class="form-input-group">
                    <i class="fas fa-paper-plane"></i>
                    <input type="text" name="reference" placeholder="Reference (optional)">
                </div>
                <button type="submit" class="btn btn-primary submit-btn">Submit</button>
            </form>
        </div>
    </div>
</body>
</html>