<?php
require 'auth_check.php';
require 'db_connect.php'; // DB কানেকশনও যুক্ত করা হলো
include 'templates/header.php';
include 'templates/sidebar.php';

// PHP-র সঠিক পাথ খুঁজে বের করার চেষ্টা
$php_path = 'php'; 
if (defined('PHP_BINARY') && is_executable(PHP_BINARY)) {
    $php_path = PHP_BINARY;
}

$script_path = __DIR__ . '/run_updater.php';
// Cron Job কমান্ড তৈরি
$cron_command = "{$php_path} -q {$script_path} >/dev/null 2>&1";
?>
<div class="page-container">
    <div class="page-header">
        <h1 class="page-title">Application Updater</h1>
    </div>

    <!-- ★★★ নতুন ম্যানুয়াল আপডেট সেকশন ★★★ -->
    <div class="content-card" style="margin-bottom: 20px;">
        <h3>Check for Updates Manually</h3>
        <p>Your current application version is: <strong><?php echo APP_VERSION; ?></strong></p>
        <p>Latest available version: <strong id="latest-version-display">Checking...</strong></p>
        
        <button id="manualUpdateBtn" class="btn btn-primary">
            <i class="fas fa-sync-alt"></i> Check for Updates
        </button>
        
        <div id="update-status" style="margin-top: 15px; padding: 10px; border-radius: 8px; display: none;"></div>
    </div>

    <div class="content-card">
        <h3>Automatic Updates Setup (Cron Job)</h3>
        <p>To enable automatic updates, you need to set up a Cron Job on your server's control panel (e.g., cPanel).</p>
        
        <div class="form-group">
            <label>Cron Command</label>
            <p>Copy the following command and add it as a new cron job. It is recommended to run it once every 24 hours.</p>
            <pre><code><?php echo htmlspecialchars($cron_command); ?></code></pre>
        </div>

        <h4>How to set up in cPanel:</h4>
        <ol>
            <li>Log in to your cPanel.</li>
            <li>Find and click on the "Cron Jobs" icon in the "Advanced" section.</li>
            <li>Under "Add New Cron Job", select "Once a Day" from the "Common Settings" dropdown.</li>
            <li>Paste the command above into the "Command" field.</li>
            <li>Click "Add New Cron Job".</li>
        </ol>
    </div>
</div>

<!-- ★★★ নতুন স্টাইল এবং জাভাস্ক্রিপ্ট ★★★ -->
<style>
    #update-status.info { background-color: #cff4fc; color: #055160; }
    #update-status.success { background-color: #d1e7dd; color: #0f5132; }
    #update-status.error { background-color: #f8d7da; color: #842029; }
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const updateBtn = document.getElementById('manualUpdateBtn');
    const statusDiv = document.getElementById('update-status');
    const latestVersionDisplay = document.getElementById('latest-version-display');

    // পেজ লোড হওয়ার সাথে সাথে লেটেস্ট ভার্সন চেক করার জন্য একটি ফাংশন
    function checkLatestVersion() {
        latestVersionDisplay.textContent = 'Checking...';
        fetch('api/check_update.php', { // কেন্দ্রীয় সার্ভারকে সরাসরি কল করা হচ্ছে
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: new URLSearchParams({
                'license_key': '<?php echo LICENSE_KEY; ?>',
                'current_version': '<?php echo APP_VERSION; ?>'
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.update_available) {
                latestVersionDisplay.textContent = data.version + ' (Update available)';
            } else {
                latestVersionDisplay.textContent = '<?php echo APP_VERSION; ?> (You are up-to-date)';
            }
        })
        .catch(error => {
            latestVersionDisplay.textContent = 'Could not check.';
        });
    }

    // পেজ লোড হলেই একবার ভার্সন চেক করা হবে
    checkLatestVersion();

    updateBtn.addEventListener('click', function() {
        this.disabled = true;
        this.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Processing Update...';

        statusDiv.style.display = 'block';
        statusDiv.className = 'info';
        statusDiv.textContent = 'Starting update process... This may take a few moments. Please do not close this window.';

        // আমাদের তৈরি করা লোকাল API হ্যান্ডলারকে কল করা হচ্ছে
        fetch('manual_update_handler.php', {
            method: 'POST'
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                statusDiv.className = 'success';
                statusDiv.textContent = data.message + ' Page will reload automatically.';
                // ২ সেকেন্ড পর পেজ রিফ্রেশ হবে যাতে নতুন ভার্সন দেখা যায়
                setTimeout(() => {
                    window.location.reload();
                }, 2000);
            } else {
                statusDiv.className = 'error';
                statusDiv.textContent = 'Error: ' + data.message;
                this.disabled = false;
                this.innerHTML = '<i class="fas fa-sync-alt"></i> Try Again';
            }
        })
        .catch(error => {
            statusDiv.className = 'error';
            statusDiv.textContent = 'A network error occurred. Please check the update_log.txt file for more details.';
            this.disabled = false;
            this.innerHTML = '<i class="fas fa-sync-alt"></i> Try Again';
        });
    });
});
</script>

<?php include 'templates/footer.php'; ?>