<?php
// update_manager.php (v3.4 - Absolute Path Final Fix)

require 'auth_check.php';
require 'db_connect.php'; 

// হেডার এবং সাইডবার লোড করা হচ্ছে
include __DIR__ . '/templates/header.php';
include __DIR__ . '/templates/sidebar.php';

// Cron Job কমান্ড তৈরির জন্য PHP কোড
$php_path = '/usr/local/bin/php';
if (defined('PHP_BINARY') && is_executable(PHP_BINARY) && strpos(PHP_BINARY, 'lsphp') === false) {
    $php_path = PHP_BINARY;
}
$script_path = __DIR__ . '/run_updater.php';
$log_path = __DIR__ . '/cron_log.txt';
$cron_command_only = "{$php_path} -q {$script_path} >> {$log_path} 2>&1";
?>

<!-- পেজের মূল HTML কন্টেন্ট শুরু -->
<div class="page-container">
    <div class="page-header">
        <div>
            <p class="breadcrumbs">Brand Settings > Version Updates</p>
            <h1 class="page-title">Application Updater</h1>
        </div>
    </div>

    <div class="content-card" style="margin-bottom: 20px;">
        <h3>Update Status</h3>
        <p>Your current version: <strong><?php echo defined('APP_VERSION') ? htmlspecialchars(APP_VERSION) : 'N/A'; ?></strong></p>
        
        <div id="update-status-area">
            <p id="status-text">Checking for new updates...</p>
            
            <div id="manual-update-box" style="display: none; border: 2px solid #7367f0; padding: 20px; border-radius: 12px; margin-top: 15px; background-color: #e9e7fd;">
                <h4 style="margin-top:0; font-size: 1.3rem; color: #5e50ee;">A new version is ready to install!</h4>
                <p>New Version: <strong id="new-version-number" style="font-size: 1.1rem; color: #333;"></strong></p>
                <button id="install-now-btn" class="btn btn-primary" style="padding: 12px 25px; font-size: 1rem;">
                    <i class="material-icons-sharp" style="font-size: 1.2rem; margin-right: 8px;">download</i> Install Now
                </button>
            </div>
            
            <div id="install-progress" style="display: none; margin-top: 15px;">
                <p id="progress-text">Installing update... Please do not close this window.</p>
                <div class="progress-bar-container">
                    <div id="progress-bar" class="progress-bar">0%</div>
                </div>
            </div>
        </div>

        <div id="final-message" style="margin-top: 15px; padding: 15px; border-radius: 8px; display: none; font-weight: 500;"></div>
    </div>

    <div class="content-card">
        <h3>Automatic Updates Setup (Cron Job)</h3>
        <p>To enable automatic updates, set up a Cron Job on your server's control panel (e.g., cPanel).</p>
        <div class="form-group" style="margin-top: 20px;">
            <label>Timing (Common Settings)</label>
            <pre><code>Once Per Five Minutes (*/5 * * * *)</code></pre>
        </div>
        <div class="form-group">
            <label>Command</label>
            <pre><code><?php echo htmlspecialchars($cron_command_only); ?></code></pre>
        </div>
    </div>
</div>

<!-- এই পেজের জন্য নির্দিষ্ট স্টাইল -->
<style>
    #final-message.success { background-color: #d1e7dd; color: #0f5132; }
    #final-message.error { background-color: #f8d7da; color: #842029; }
    .progress-bar-container { width: 100%; background-color: #e9ecef; border-radius: 8px; }
    .progress-bar { width: 0%; height: 25px; background-color: var(--primary-color); text-align: center; line-height: 25px; color: white; border-radius: 8px; transition: width 0.4s ease; }
    pre { background-color: #282c34; color: #abb2bf; padding: 20px; border-radius: 8px; overflow-x: auto; white-space: pre-wrap; font-family: 'Courier New', Courier, monospace; }
    @keyframes spin { 100% { transform: rotate(360deg); } }
</style>

<!-- এই পেজের জন্য নির্দিষ্ট জাভাস্ক্রিপ্ট -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const statusText = document.getElementById('status-text');
    const manualUpdateBox = document.getElementById('manual-update-box');
    const newVersionDisplay = document.getElementById('new-version-number');
    const installBtn = document.getElementById('install-now-btn');
    const installProgress = document.getElementById('install-progress');
    const finalMessage = document.getElementById('final-message');
    const progressBar = document.getElementById('progress-bar');
    
    const licenseKey = '<?php echo defined('LICENSE_KEY') ? LICENSE_KEY : ''; ?>';
    const currentVersion = '<?php echo defined('APP_VERSION') ? APP_VERSION : '0.0.0'; ?>';

    function checkForUpdates() {
        if (!licenseKey || !statusText) return;
        statusText.textContent = 'Checking for new updates...';
        fetch('manual_update_handler.php?action=check', {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: new URLSearchParams({'license_key': licenseKey, 'current_version': currentVersion})
        })
        .then(response => response.json())
        .then(data => {
            if (data.update_available && data.update_type === 'manual') {
                statusText.textContent = 'A new update is available for installation.';
                if(newVersionDisplay) newVersionDisplay.textContent = data.version;
                if(manualUpdateBox) manualUpdateBox.style.display = 'block';
            } else if (!data.update_available || (data.update_available && data.update_type === 'automatic')) {
                statusText.textContent = 'Your application is up-to-date.';
                statusText.style.color = '#198754';
                statusText.style.fontWeight = '500';
            } else {
                throw new Error(data.message || 'Invalid response from server.');
            }
        })
        .catch(error => {
            statusText.textContent = 'Could not check for updates: ' + error.message;
            statusText.style.color = 'var(--danger-color)';
        });
    }

    if(installBtn) {
        installBtn.addEventListener('click', function() {
            this.disabled = true;
            this.innerHTML = '<i class="material-icons-sharp" style="animation: spin 1s linear infinite;">sync</i> Installing...';
            if(manualUpdateBox) manualUpdateBox.style.display = 'none';
            if(statusText) statusText.style.display = 'none';
            if(installProgress) installProgress.style.display = 'block';

            let width = 10;
            const interval = setInterval(() => {
                if (width < 90) { 
                    width += Math.floor(Math.random() * 10);
                    if(progressBar) {
                        progressBar.style.width = width + '%';
                        progressBar.textContent = width + '%';
                    }
                }
            }, 300);

            fetch('manual_update_handler.php?action=install', { method: 'POST' })
            .then(response => response.json())
            .then(data => {
                clearInterval(interval);
                if(progressBar) {
                    progressBar.style.width = '100%';
                    progressBar.textContent = '100%';
                }
                if(installProgress) installProgress.style.display = 'none';
                if(finalMessage) finalMessage.style.display = 'block';

                if (data.success) {
                    finalMessage.className = 'success';
                    finalMessage.textContent = data.message + ' Page will reload shortly.';
                    setTimeout(() => { window.location.reload(); }, 3000);
                } else {
                    finalMessage.className = 'error';
                    finalMessage.textContent = 'Update Failed: ' + (data.message || 'Unknown error.');
                    this.disabled = false;
                    this.innerHTML = '<i class="material-icons-sharp">download</i> Try Again';
                }
            })
            .catch(error => {
                clearInterval(interval);
                if(installProgress) installProgress.style.display = 'none';
                if(finalMessage) finalMessage.style.display = 'block';
                finalMessage.className = 'error';
                finalMessage.textContent = 'A network error occurred. Please check your log files.';
                this.disabled = false;
                this.innerHTML = '<i class="material-icons-sharp">download</i> Try Again';
            });
        });
    }

    checkForUpdates();
});
</script>

<?php 
// ★★★ চূড়ান্ত সমাধান: __DIR__ ব্যবহার করে ফুটার লোড করা হচ্ছে ★★★
// এটি নিশ্চিত করবে যে জাভাস্ক্রিপ্ট ফাইলটি সব সময় লোড হবে।
include __DIR__ . '/templates/footer.php'; 
?>