<?php
header('Content-Type: application/json');
require '../db_connect.php';

// API Key দিয়ে অথেন্টিকেশন
$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';
if (empty($api_key)) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'API Key is missing.']);
    exit();
}

$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting = $stmt_user->fetch(PDO::FETCH_ASSOC);

if (!$setting) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Invalid API Key.']);
    exit();
}
$user_id = $setting['user_id'];

// ফিল্টার এবং সার্চ প্যারামিটার গ্রহণ
$filter = $_GET['filter'] ?? 'all';
$search = trim($_GET['search'] ?? '');

try {
    $sql = "SELECT id, sender_number, amount, transaction_id, status, received_at FROM sms_transactions";
    $conditions = ["user_id = ?"];
    $params = [$user_id];

    // is_trashed কলামের উপর ভিত্তি করে ফিল্টার
    if ($filter === 'trashed') {
        $conditions[] = "is_trashed = 1";
    } else {
        $conditions[] = "is_trashed = 0";
        if ($filter === 'received' || $filter === 'verified') {
            $conditions[] = "status = ?";
            $params[] = ucfirst($filter);
        }
    }

    // সার্চ টার্ম প্রয়োগ
    if (!empty($search)) {
        $conditions[] = "(sender_number LIKE ? OR transaction_id LIKE ?)";
        $params[] = "%{$search}%";
        $params[] = "%{$search}%";
    }

    $sql .= " WHERE " . implode(' AND ', $conditions);
    $sql .= " ORDER BY received_at DESC";

    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $sms_data = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // তারিখকে পাঠযোগ্য ফরম্যাটে রূপান্তর
    foreach ($sms_data as &$sms) {
        $sms['received_at'] = date("d M, Y, g:i A", strtotime($sms['received_at']));
    }

    echo json_encode($sms_data);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error.', 'error_details' => $e->getMessage()]);
}
?>