<?php
header('Content-Type: application/json');
require '../db_connect.php';

// API Key Authentication
$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';
if (empty($api_key)) { http_response_code(401); die(json_encode(['success' => false, 'message' => 'API Key is missing.'])); }

$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting = $stmt_user->fetch(PDO::FETCH_ASSOC);
if (!$setting) { http_response_code(403); die(json_encode(['success' => false, 'message' => 'Invalid API Key.'])); }

$user_id = $setting['user_id'];
$sms_id = $_POST['id'] ?? null;

if (!$sms_id) {
    http_response_code(400);
    die(json_encode(['success' => false, 'message' => 'SMS Record ID is required.']));
}

try {
    // is_trashed ফ্ল্যাগটি 0-এ সেট করে পুনরুদ্ধার করা হচ্ছে
    $sql = "UPDATE sms_transactions SET is_trashed = 0 WHERE id = :id AND user_id = :user_id";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([':id' => $sms_id, ':user_id' => $user_id]);

    if ($stmt->rowCount() > 0) {
        echo json_encode(['success' => true, 'message' => 'Record restored successfully.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Record not found or permission denied.']);
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error.']);
}
?>