<?php
// ★★★ এই ফাইলটি এখন ইনস্টলার দ্বারা তৈরি config.php থেকে তথ্য পড়বে ★★★

// config.php ফাইলটি আছে কিনা তা পরীক্ষা করা
if (!file_exists(__DIR__ . '/config.php')) {
    // যদি না থাকে, তাহলে ব্যবহারকারীকে সেটআপ পেজে পাঠানো হবে
    if (file_exists(__DIR__ . '/install/index.php')) {
        header('Location: install/index.php');
        exit;
    }
    die("CRITICAL ERROR: Configuration file is missing and the installer could not be found. Please re-upload all files.");
}

require_once __DIR__ . '/config.php';

$host = defined('DB_HOST') ? DB_HOST : 'localhost';
$dbname = defined('DB_NAME') ? DB_NAME : '';
$username = defined('DB_USER') ? DB_USER : '';
$password = defined('DB_PASS') ? DB_PASS : '';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    // এরর মোড সেট করা
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Could not connect to the database. Please check your configuration. Error: " . $e->getMessage());
}
?>