<?php
// ব্যবহারকারী লগইন করা আছে কিনা তা পরীক্ষা করা
require 'auth_check.php';
// ডেটাবেস সংযোগ ফাইল যুক্ত করা
require 'db_connect.php'; 

// টেমপ্লেট লোড
include 'templates/header.php';
include 'templates/sidebar.php';

$user_id = $_SESSION['user_id'];

// 'transactions' টেবিল থেকে ডেটা আনা হচ্ছে
$stmt = $pdo->prepare("
    SELECT id, customer_name, customer_email, amount, 'BDT' as currency, user_submitted_trxid as transaction_id, status, created_at 
    FROM transactions 
    WHERE user_id = ? 
    ORDER BY created_at DESC
");
$stmt->execute([$user_id]);
$payments = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!-- পেমেন্টস পেজের মূল কন্টেন্ট -->
<div class="page-container">
    <div class="page-header">
        <div>
            <p class="breadcrumbs">Gateway > Payments</p>
            <h1 class="page-title">All Payments</h1>
        </div>
    </div>

    <div class="content-card">
        <div class="card-toolbar">
            <div class="toolbar-left"></div>
            <div class="toolbar-right">
                <div class="search-box">
                    <i class="fas fa-search"></i>
                    <input type="text" placeholder="Search by name or email">
                </div>
            </div>
        </div>

        <table class="data-table">
            <thead>
                <tr>
                    <th>Customer Name</th>
                    <th>Customer Email</th>
                    <th>Amount</th>
                    <th>Transaction ID</th>
                    <th>Status</th>
                    <th>Date</th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($payments) > 0): ?>
                    <?php foreach ($payments as $payment): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($payment['customer_name'] ?: 'N/A'); ?></td>
                            <td><?php echo htmlspecialchars($payment['customer_email'] ?: 'N/A'); ?></td>
                            <td><?php echo number_format($payment['amount'], 2); ?> <?php echo htmlspecialchars($payment['currency']); ?></td>
                            <td><?php echo htmlspecialchars($payment['transaction_id'] ?: 'N/A'); ?></td>
                            <td>
                                <span class="status-badge status-<?php echo strtolower(htmlspecialchars($payment['status'])); ?>">
                                    <?php echo htmlspecialchars(ucfirst($payment['status'])); ?>
                                </span>
                            </td>
                            <td><?php echo date("d M, Y, g:i A", strtotime($payment['created_at'])); ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="6" style="text-align:center; padding: 20px;">No payments have been recorded yet.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
        
        <div class="card-footer">
            <div class="pagination-controls">
                <span>Per page</span>
                <select>
                    <option value="10" selected>10</option>
                    <option value="20">20</option>
                    <option value="50">50</option>
                </select>
            </div>
        </div>
    </div>
</div>

<?php
// ফুটার টেমপ্লেট লোড
include 'templates/footer.php';
?>