<?php
// config.php ফাইলটি auth_check.php এর মাধ্যমে লোড হয়
if (file_exists(__DIR__ . '/../config.php')) {
    require_once __DIR__ . '/../config.php';
}
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ড্যাশবোর্ড</title>
    
    <!-- ফন্ট এবং আইকনসমূহ -->
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons+Sharp" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- মূল স্টাইলশিট -->
    <link rel="stylesheet" href="css/style.css?v=<?php echo @filemtime('css/style.css'); ?>">

</head>
<body data-license-key="<?php echo defined('LICENSE_KEY') ? LICENSE_KEY : ''; ?>" data-app-version="<?php echo defined('APP_VERSION') ? APP_VERSION : '0.0.0'; ?>">

<!-- ★★★ সমাধান: আপডেট নোটিফিকেশন পপ-আপ এখানে যুক্ত করা হয়েছে ★★★ -->
<div id="update-notification-overlay" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0, 0, 0, 0.6); z-index: 1050; align-items: center; justify-content: center;">
    <div style="background-color: #fff; padding: 30px; border-radius: 12px; box-shadow: 0 5px 20px rgba(0,0,0,0.2); width: 90%; max-width: 450px; text-align: center; position: relative;">
        <button id="close-update-popup-btn" style="position: absolute; top: 10px; right: 15px; background: none; border: none; font-size: 2rem; color: #aaa; cursor: pointer; line-height: 1;">&times;</button>
        <h3 style="margin-top: 0; font-size: 1.5rem; color: #7367f0;"><i class="material-icons-sharp" style="vertical-align: bottom; font-size: 1.8rem; margin-right: 5px;">info</i> New Update Available</h3>
        <p style="color: #4E4B66; margin: 15px 0 25px 0;">A new software version is available. Please visit the update page to install it.</p>
        <div style="display: flex; justify-content: center; gap: 15px;">
            <button id="remind-later-btn" class="btn btn-secondary">Remind Me Later</button>
            <a href="update_manager.php" class="btn btn-primary">Check Update</a>
        </div>
    </div>
</div>

<div class="dashboard-container">
    <!-- সাইডবার এখানে include করা হবে -->