<?php
header('Content-Type: application/json');
require '../db_connect.php';

// API Key দিয়ে অথেন্টিকেশন
$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';
if (empty($api_key)) { http_response_code(401); die(json_encode(['success' => false, 'message' => 'API Key is missing.'])); }

$stmt_user = $pdo->prepare("SELECT user_id, username, email FROM settings s JOIN users u ON s.user_id = u.id WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$user = $stmt_user->fetch(PDO::FETCH_ASSOC);
if (!$user) { http_response_code(403); die(json_encode(['success' => false, 'message' => 'Invalid API Key.'])); }

$user_id = $user['user_id'];

define('USD_TO_BDT_RATE', 120);

$amount_usd = (float)($_POST['amount'] ?? 0);

if ($amount_usd <= 0) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Invalid amount provided.']);
    exit();
}

$amount_bdt = $amount_usd * USD_TO_BDT_RATE;
$transaction_unique_id = sha1(uniqid(rand(), true) . microtime());

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https" : "http";
$host = $_SERVER['HTTP_HOST'];
$directory = rtrim(dirname(dirname($_SERVER['PHP_SELF'])), '/\\');
$base_project_url = "{$protocol}://{$host}{$directory}";

// ★★★ সমাধান: এখন অ্যাপের জন্য একটি পাবলিক রিডাইরেক্ট পেজ ব্যবহার করা হচ্ছে ★★★
$success_url = "{$base_project_url}/app_redirect.php?funding_status=success&trx_id=" . $transaction_unique_id;
$cancel_url = "{$base_project_url}/app_redirect.php?funding_status=cancelled";

try {
    $pdo->beginTransaction();

    $stmt_funds = $pdo->prepare(
        "INSERT INTO user_funds (user_id, transaction_unique_id, amount_usd, amount_bdt, status) 
         VALUES (?, ?, ?, ?, 'pending')"
    );
    $stmt_funds->execute([$user_id, $transaction_unique_id, $amount_usd, $amount_bdt]);

    $stmt_trans = $pdo->prepare(
        "INSERT INTO transactions (user_id, unique_id, amount, customer_name, customer_email, success_url, cancel_url, meta_data) 
         VALUES (?, ?, ?, ?, ?, ?, ?, ?)"
    );
    $stmt_trans->execute([
        $user_id, $transaction_unique_id, $amount_bdt,
        $user['username'] ?? 'User', $user['email'] ?? 'funding@user.com',
        $success_url, $cancel_url,
        json_encode(['source' => 'user_funding', 'amount_usd' => $amount_usd])
    ]);

    $pdo->commit();

    $payment_url = "{$base_project_url}/checkout.php?trx_id={$transaction_unique_id}";
    echo json_encode(['success' => true, 'payment_url' => $payment_url]);

} catch (PDOException $e) {
    if ($pdo->inTransaction()) $pdo->rollBack();
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Failed to initiate funding session.', 'error' => $e->getMessage()]);
}
?>