<?php
// manual_update_handler.php (AJAX Handler for the Updater UI)

header('Content-Type: application/json');
require_once 'auth_check.php';
require_once 'updater_logic.php';

$action = $_GET['action'] ?? 'install'; // ডিফল্ট অ্যাকশন 'install'

if ($action === 'check') {
    // শুধুমাত্র আপডেটের তথ্য চেক করে ফেরত পাঠানো
    try {
        if (!defined('APP_VERSION')) require_once __DIR__ . '/config.php';
        
        $central_api_url = 'https://settings.top/dashboard_project/api/check_update.php';
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $central_api_url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
            'license_key' => LICENSE_KEY, 
            'current_version' => APP_VERSION
        ]));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);
        
        // সার্ভার থেকে পাওয়া রেসপন্স সরাসরি ক্লায়েন্টকে পাঠানো হচ্ছে
        echo $response;

    } catch (Exception $e) {
        echo json_encode(['update_available' => false, 'message' => $e->getMessage()]);
    }

} elseif ($action === 'install') {
    // ব্যবহারকারী 'Install' বাটনে ক্লিক করলে এই অংশটি কাজ করবে
    // এবং মূল আপডেট ফাংশনটি চালাবে
    $result = perform_update();
    echo json_encode($result);
}
?>