<?php
header('Content-Type: application/json');
require '../db_connect.php';

$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';

if (empty($api_key)) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'API Key is missing.']);
    exit();
}

$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting = $stmt_user->fetch(PDO::FETCH_ASSOC);

if (!$setting) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Invalid API Key.']);
    exit();
}
$user_id = $setting['user_id'];

// Data sent from the app
$gateway_key = $_POST['gateway_key'] ?? '';

if (empty($gateway_key)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Gateway key is required.']);
    exit();
}

// Set the default display name based on the gateway key
$display_name = '';
// ★★★ FIX: Added all other gateway options to be recognized by the API ★★★
if ($gateway_key === 'bkash_personal') $display_name = 'Bkash Personal';
else if ($gateway_key === 'nagad_personal') $display_name = 'Nagad Personal';
else if ($gateway_key === 'rocket_personal') $display_name = 'Rocket Personal';
else if ($gateway_key === 'upay_personal') $display_name = 'Upay Personal';
else if ($gateway_key === 'bkash_merchant_tokenized') $display_name = 'bKash Marchant (Tokenized)';
else if ($gateway_key === 'nagad_merchant') $display_name = 'Nagad Marchant';
else if ($gateway_key === 'bkash_merchant_checkout') $display_name = 'bKash Marchant (Checkout)';


if (!empty($display_name)) {
    $sql = "INSERT INTO gateways (user_id, display_name, gateway_key) VALUES (:user_id, :display_name, :gateway_key)";
    $stmt = $pdo->prepare($sql);
    
    if ($stmt->execute(['user_id' => $user_id, 'display_name' => $display_name, 'gateway_key' => $gateway_key])) {
        echo json_encode(['success' => true, 'message' => 'Gateway created successfully.']);
    } else {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Failed to create gateway.']);
    }
} else {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Invalid gateway key provided.']);
}
?>