<?php
header('Content-Type: application/json');
require '../db_connect.php';

// API Key Authentication
$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';
if (empty($api_key)) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'API Key is missing.']);
    exit();
}
$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting = $stmt_user->fetch(PDO::FETCH_ASSOC);
if (!$setting) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Invalid API Key.']);
    exit();
}
$user_id = $setting['user_id'];

$response = ['success' => false, 'url' => '', 'message' => 'Link not found.'];
$link_id = $_POST['id'] ?? null;

if ($link_id) {
    $stmt = $pdo->prepare("SELECT unique_link_id FROM payment_links WHERE id = ? AND user_id = ?");
    $stmt->execute([$link_id, $user_id]);
    $link = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($link) {
        $unique_id = $link['unique_link_id'];
        if (empty($unique_id)) {
            $unique_id = bin2hex(random_bytes(20));
            $pdo->prepare("UPDATE payment_links SET unique_link_id = ? WHERE id = ?")->execute([$unique_id, $link_id]);
        }
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https" : "http";
        $host = $_SERVER['HTTP_HOST'];
        $directory = rtrim(dirname(dirname($_SERVER['PHP_SELF'])), '/\\');
        
        $response['url'] = "{$protocol}://{$host}{$directory}/paymentlink/pay/{$unique_id}";
        $response['success'] = true;
        $response['message'] = "Link retrieved.";
    }
}

echo json_encode($response);
?>