<?php
require 'auth_check.php';
require 'db_connect.php';
include 'templates/header.php';
include 'templates/sidebar.php';

$user_id = $_SESSION['user_id'];
$stmt = $pdo->prepare("SELECT * FROM devices WHERE user_id = ? ORDER BY id DESC");
$stmt->execute([$user_id]);
$devices = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="page-container">
    <div class="page-header">
        <div>
            <p class="breadcrumbs">Devices > List</p>
            <h1 class="page-title">Devices</h1>
        </div>
        <!-- সাইড প্যানেল খোলার জন্য এই বাটনে একটি আইডি যুক্ত করা হয়েছে -->
        <a href="#" id="connectAppBtn" class="btn btn-primary">
            <i class="fas fa-wifi"></i> Connect Android App
        </a>
    </div>

    <div class="content-card">
        <!-- ... আপনার টেবিলের বাকি অংশ এখানে থাকবে ... -->
        <table class="data-table">
            <thead>
                <tr>
                    <th><input type="checkbox"></th>
                    <th>Device ID <i class="fas fa-chevron-down"></i></th>
                    <th>Device name <i class="fas fa-chevron-down"></i></th>
                    <th>Device model <i class="fas fa-chevron-down"></i></th>
                    <th>Android Version <i class="fas fa-chevron-down"></i></th>
                    <th>App Version</th>
                    <th>Status <i class="fas fa-chevron-down"></i></th>
                    <th style="text-align: right;">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($devices) > 0): ?>
                    <?php foreach ($devices as $device): ?>
                        <tr>
                            <td><input type="checkbox"></td>
                            <td><?php echo htmlspecialchars($device['device_id']); ?></td>
                            <td><?php echo htmlspecialchars($device['device_name']); ?></td>
                            <td><?php echo htmlspecialchars($device['device_model']); ?></td>
                            <td><?php echo htmlspecialchars($device['android_version']); ?></td>
                            <td><?php echo htmlspecialchars($device['app_version']); ?></td>
                            <td>
                                <span class="status-badge status-<?php echo strtolower(htmlspecialchars($device['status'])); ?>">
                                    <?php echo htmlspecialchars($device['status']); ?>
                                </span>
                            </td>
                            <td class="actions" style="text-align: right;">
                                <a href="#" class="action-delete"><i class="fas fa-trash-alt"></i> Delete</a>
                                <a href="#" class="action-verify"><i class="fas fa-shield-alt"></i> Balance Verification</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="8" style="text-align:center; padding: 20px;">No devices have been connected yet.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

</div> <!-- .main-content বন্ধ করার ট্যাগ -->

<!-- === নতুন সাইড প্যানেলের HTML কোড === -->
<div id="connectAppPanel" class="side-panel-overlay">
    <div class="side-panel">
        <div class="side-panel-header">
            <h3>Connect Android App</h3>
            <button id="closePanelBtn" class="close-panel-btn">&times;</button>
        </div>
        <div class="side-panel-body">
            <!-- বাম কলাম: অ্যাপ ডাউনলোড -->
            <div class="panel-card">
                <div class="panel-card-header">
                    <h4>Download Android App</h4>
                    <span>&#9650;</span>
                </div>
                <div class="panel-card-body">
                    <h2>Get the Payment Automation App</h2>
                    <p class="subtitle">Only for Bangladeshi Users</p>
                    <p>Download our Android app to automate your personal payments effortlessly.</p>
                    <ul class="features-list">
                        <li><i class="fas fa-check-circle"></i> Automatically verify your transactions.</li>
                        <li><i class="fas fa-check-circle"></i> Grant necessary permissions for seamless operation.</li>
                        <li><i class="fas fa-check-circle"></i> Secure background verification of your payments.</li>
                        <li><i class="fas fa-check-circle"></i> View verified transactions in the <strong>SMS Data</strong> section.</li>
                    </ul>
                    <a href="#" class="btn btn-primary download-btn">
                        <i class="fas fa-download"></i> Download Android App
                    </a>
                </div>
            </div>
            <!-- ডান কলাম: QR কোড -->
            <div class="panel-card">
                 <div class="panel-card-header">
                    <h4>Connect Android App</h4>
                    <span>&#9650;</span>
                </div>
                <div class="panel-card-body qr-section">
                    <h4>Link Your Device</h4>
                    <p>Open the app and scan this QR code to connect.</p>
                    <div class="qr-code-container">
                        <!-- ডাইনামিক QR কোড এখানে লোড হবে -->
                        <img src="generate_qr.php" alt="Scan to connect">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="js/main.js?v=<?php echo filemtime('js/main.js'); ?>"></script>
<!-- সাইড প্যানেল নিয়ন্ত্রণের জন্য JavaScript -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const connectBtn = document.getElementById('connectAppBtn');
    const closeBtn = document.getElementById('closePanelBtn');
    const panelOverlay = document.getElementById('connectAppPanel');

    if (connectBtn) {
        connectBtn.addEventListener('click', function(e) {
            e.preventDefault();
            panelOverlay.classList.add('open');
        });
    }

    if (closeBtn) {
        closeBtn.addEventListener('click', function() {
            panelOverlay.classList.remove('open');
        });
    }

    // প্যানেলের বাইরে ক্লিক করলেও বন্ধ হয়ে যাবে
    if (panelOverlay) {
        panelOverlay.addEventListener('click', function(e) {
            if (e.target === panelOverlay) {
                panelOverlay.classList.remove('open');
            }
        });
    }
});
</script>
</body>
</html>