<?php
/**
 * Login page for the self-hosted instance.
 * Version 2.2 - Clears update notification status on load.
 */

session_start();

if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in'] === true) {
    header("Location: index.php");
    exit();
}

if (!file_exists(__DIR__ . '/config.php')) {
    header('Location: install/index.php');
    exit;
}
require_once __DIR__ . '/config.php';

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'];
    $password = $_POST['password'];

    $central_api_url = 'https://settings.top/dashboard_project/api/validate_login.php';
    $license_key = defined('LICENSE_KEY') ? LICENSE_KEY : '';

    if (empty($license_key)) {
        $error = 'License key is missing from the configuration file. Please reinstall the application.';
    } else {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $central_api_url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
            'username' => $username,
            'password' => $password,
            'license_key' => $license_key
        ]));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        $result = json_decode($response, true);

        if ($http_code === 200 && $result && isset($result['success']) && $result['success']) {
            $_SESSION['user_logged_in'] = true;
            $_SESSION['username'] = $username;
            $_SESSION['user_id'] = $result['user_id'];

            header("Location: index.php");
            exit();
        } else {
            $error = $result['message'] ?? 'Login failed. An unknown error occurred.';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Login</title>
    <link rel="stylesheet" href="css/style.css?v=<?php echo @filemtime('css/style.css'); ?>">
</head>
<body class="auth-body">
    <div class="auth-container">
        <h2 class="auth-title">Dashboard Login</h2>
        <?php if (!empty($error)): ?>
            <div class="auth-errors"><p><?php echo htmlspecialchars($error); ?></p></div>
        <?php endif; ?>
        <form action="login.php" method="POST">
            <div class="form-group">
                <label for="username">Username</label>
                <input type="text" id="username" name="username" required>
            </div>
            <div class="form-group">
                <label for="password">Password</label>
                <input type="password" id="password" name="password" required>
            </div>
            <button type="submit" class="btn btn-primary auth-btn">Login</button>
        </form>
    </div>

    <!-- ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★ -->
    <!-- ★★★               মূল সমাধান এখানে              ★★★ -->
    <!-- ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★ -->
    <script>
        // এই পেজটি লোড হওয়ার সাথে সাথে sessionStorage থেকে আপডেটের নোটিফিকেশন স্ট্যাটাস মুছে ফেলা হচ্ছে।
        // এর ফলে, ব্যবহারকারী লগআউট করার পর বা নতুন করে লগইন করতে আসলে, নোটিফিকেশনটি আবার চেক হবে।
        sessionStorage.removeItem('updateNoticeDismissed');
    </script>
    <!-- ★★★                সমাধান শেষ                 ★★★ -->

</body>
</html>