<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ড্যাশবোর্ড</title>
    <link rel="stylesheet" href="css/style.css?v=<?php echo @filemtime('css/style.css'); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        .update-notification-overlay {
            position: fixed; top: 0; left: 0; width: 100%; height: 100%;
            background-color: rgba(0, 0, 0, 0.6); z-index: 1050; display: none;
            align-items: center; justify-content: center;
        }
        .update-notification-modal {
            background-color: #fff; padding: 30px; border-radius: 12px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.2); width: 90%; max-width: 450px;
            text-align: center; position: relative;
        }
        .update-notification-modal h3 { margin-top: 0; font-size: 1.5rem; color: #0d6efd; }
        .update-notification-modal p { color: #495057; margin: 15px 0 25px 0; }
        .update-notification-actions { display: flex; justify-content: center; gap: 15px; }
        .update-notification-close-btn {
            position: absolute; top: 10px; right: 15px; background: none; border: none;
            font-size: 2rem; color: #aaa; cursor: pointer; line-height: 1; padding: 0;
        }
        .update-notification-close-btn:hover { color: #000; }
    </style>
</head>
<body>
    <header class="header">
        <div class="header-left">
            <div class="header-icon" id="menu-icon"><i class="fas fa-bars"></i></div>
        </div>
        <div class="header-title"><h1>আমার ওয়েবসাইট</h1></div>
        <div class="header-right">
            <a href="logout.php" class="header-icon"><i class="fas fa-sign-out-alt"></i></a>
        </div>
    </header>

    <div id="update-notification-overlay" class="update-notification-overlay">
        <div class="update-notification-modal">
            <button id="close-update-popup-btn" class="update-notification-close-btn">&times;</button>
            <h3><i class="fas fa-info-circle"></i> New Update Available</h3>
            <p>A new software update is available. Please visit the update page to install it.</p>
            <div class="update-notification-actions">
                <button id="remind-later-btn" class="btn btn-secondary">Remind Me Later</button>
                <a href="update_manager.php" class="btn btn-primary">Check Update</a>
            </div>
        </div>
    </div>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const modalOverlay = document.getElementById('update-notification-overlay');
        const remindLaterBtn = document.getElementById('remind-later-btn');
        const closePopupBtn = document.getElementById('close-update-popup-btn');
        
        const licenseKey = '<?php echo defined('LICENSE_KEY') ? LICENSE_KEY : ''; ?>';
        const currentVersion = '<?php echo defined('APP_VERSION') ? APP_VERSION : '0.0.0'; ?>';

        function showUpdatePopup() {
            if (modalOverlay) modalOverlay.style.display = 'flex';
        }
        
        function hideUpdatePopup() {
            if (modalOverlay) {
                modalOverlay.style.display = 'none';
                sessionStorage.setItem('updateNoticeDismissed', 'true');
            }
        }

        if(remindLaterBtn) remindLaterBtn.addEventListener('click', hideUpdatePopup);
        if(closePopupBtn) closePopupBtn.addEventListener('click', hideUpdatePopup);

        function checkForUpdate() {
            fetch('manual_update_handler.php?action=check', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: new URLSearchParams({
                    'license_key': licenseKey,
                    'current_version': currentVersion
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.update_available && data.update_type === 'manual') {
                    showUpdatePopup();
                }
            })
            .catch(error => console.error('Update check failed:', error));
        }
        
        const currentPage = window.location.pathname.split("/").pop();
        if (currentPage !== 'update_manager.php') {
            if (sessionStorage.getItem('updateNoticeDismissed') !== 'true') {
                checkForUpdate();
            }
        }
    });
    </script>