<?php
header('Content-Type: application/json');
require 'auth_check.php';
require 'db_connect.php';

$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);
$trx_id = $data['trx_id'] ?? null;

if (!$trx_id) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Transaction ID is missing.']);
    exit();
}

$user_id = $_SESSION['user_id'];

try {
    $pdo->beginTransaction();

    // Step 1: Find the funding record to ensure it's pending and belongs to the user
    $stmt_fund = $pdo->prepare(
        "SELECT * FROM user_funds WHERE transaction_unique_id = ? AND user_id = ? AND status = 'pending'"
    );
    $stmt_fund->execute([$trx_id, $user_id]);
    $fund_details = $stmt_fund->fetch(PDO::FETCH_ASSOC);

    if (!$fund_details) {
        throw new Exception('Funding record not found or already processed.');
    }

    // Step 2: Verify the payment status in the main transactions table
    $stmt_trans = $pdo->prepare(
        "SELECT status FROM transactions WHERE unique_id = ? AND user_id = ?"
    );
    $stmt_trans->execute([$trx_id, $user_id]);
    $transaction = $stmt_trans->fetch(PDO::FETCH_ASSOC);

    if ($transaction && $transaction['status'] === 'completed') {
        // Step 3: Update the funding record status to 'completed'
        $stmt_update_fund = $pdo->prepare(
            "UPDATE user_funds SET status = 'completed' WHERE id = ?"
        );
        $stmt_update_fund->execute([$fund_details['id']]);

        // Step 4: Add the funds to the user's balance
        $stmt_update_balance = $pdo->prepare(
            "UPDATE users SET balance = balance + ? WHERE id = ?"
        );
        $stmt_update_balance->execute([$fund_details['amount_usd'], $user_id]);
        
        $pdo->commit();
        echo json_encode(['success' => true, 'message' => 'Funds added successfully!']);
    } else {
        throw new Exception('Payment verification failed or payment is not completed.');
    }

} catch (Exception $e) {
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
