<?php
header('Content-Type: application/json');
require '../db_connect.php';

$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';
if (empty($api_key)) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'API Key is missing.']);
    exit();
}

$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting_user = $stmt_user->fetch(PDO::FETCH_ASSOC);

if (!$setting_user) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Invalid API Key.']);
    exit();
}
$user_id = $setting_user['user_id'];

// General settings আনা হচ্ছে
$stmt_general = $pdo->prepare("SELECT * FROM brand_settings WHERE user_id = ?");
$stmt_general->execute([$user_id]);
$settings = $stmt_general->fetch(PDO::FETCH_ASSOC);

// Branding (Color) settings আনা হচ্ছে
$stmt_colors = $pdo->prepare("SELECT * FROM brand_colors WHERE user_id = ?");
$stmt_colors->execute([$user_id]);
$colors = $stmt_colors->fetch(PDO::FETCH_ASSOC);

// Business Details টেবিল থেকে ডেটা আনা
$stmt_business = $pdo->prepare("SELECT * FROM business_details WHERE user_id = ?");
$stmt_business->execute([$user_id]);
$business = $stmt_business->fetch(PDO::FETCH_ASSOC);

// Support Details টেবিল থেকে ডেটা আনা
$stmt_support = $pdo->prepare("SELECT * FROM support_details WHERE user_id = ?");
$stmt_support->execute([$user_id]);
$support = $stmt_support->fetch(PDO::FETCH_ASSOC);

// Brand Logos টেবিল থেকে ডেটা আনা
$stmt_logos = $pdo->prepare("SELECT primary_logo, round_logo, favicon FROM brand_logos WHERE user_id = ?");
$stmt_logos->execute([$user_id]);
$logos = $stmt_logos->fetch(PDO::FETCH_ASSOC);

$response = [
    'success' => true,
    
    // General Settings
    'site_name' => $settings['site_name'] ?? '',
    'timezone' => $settings['timezone'] ?? 'Asia/Dhaka',
    'default_currency' => $settings['default_currency'] ?? 'BDT',
    'currency_symbol' => $settings['currency_symbol'] ?? '৳',
    'default_language' => $settings['default_language'] ?? 'en',
    'week_starts_on' => $settings['week_starts_on'] ?? 'Saturday',
    
    // Branding Settings (ডিফল্ট ভ্যালুসহ)
    'global_text_color' => $colors['global_text_color'] ?? '#000000',
    'primary_button_color' => $colors['primary_button_color'] ?? '#0D6EFD',
    'button_text_color' => $colors['button_text_color'] ?? '#FFFFFF',
    'button_hover_color' => $colors['button_hover_color'] ?? '#0B5ED7',
    'button_hover_text_color' => $colors['button_hover_text_color'] ?? '#FFFFFF',
    'navigation_background' => $colors['navigation_background'] ?? '#FFFFFF',
    'navigation_text_color' => $colors['navigation_text_color'] ?? '#000000',
    'active_tab_color' => $colors['active_tab_color'] ?? '#E9EFFF',
    'active_tab_text_color' => $colors['active_tab_text_color'] ?? '#0D6EFD',
    
    // Business Details
    'street_address' => $business['street_address'] ?? '',
    'city' => $business['city'] ?? '',
    'postal_code' => $business['postal_code'] ?? '',
    'country' => $business['country'] ?? '',
    
    // Support Details
    'support_phone' => $support['support_phone'] ?? '',
    'support_email' => $support['support_email'] ?? '',
    'support_website' => $support['support_website'] ?? '',

    // Logo paths
    'primary_logo' => $logos['primary_logo'] ?? null,
    'round_logo' => $logos['round_logo'] ?? null,
    'favicon' => $logos['favicon'] ?? null
];

echo json_encode($response);
