<?php
header('Content-Type: application/json');
require '../db_connect.php';

session_start();

// --- Configuration ---
define('FEE_PER_TRANSACTION_BDT', 1.00);
define('USD_TO_BDT_RATE_FOR_FEE', 120);

function deduct_fee_and_log($pdo, $user_id, $transaction_db_id) {
    $free_credits = 50;
    $stmt_purchased = $pdo->prepare("SELECT COALESCE(SUM(amount_bdt), 0) as total_purchased FROM user_funds WHERE user_id = ? AND status = 'completed' AND transaction_unique_id LIKE 'manual_purchase_%'");
    $stmt_purchased->execute([$user_id]);
    $purchased_credits = $stmt_purchased->fetchColumn();
    $total_available_credits = $free_credits + $purchased_credits;

    $stmt_used = $pdo->prepare("SELECT COUNT(id) FROM credit_transactions WHERE user_id = ? FOR UPDATE");
    $stmt_used->execute([$user_id]);
    $used_credits = $stmt_used->fetchColumn();

    if ($used_credits >= $total_available_credits) {
        throw new Exception("Insufficient credits to cover transaction fee. Please purchase more credits in the billing section.");
    }

    $fee_bdt = FEE_PER_TRANSACTION_BDT;
    $fee_usd = $fee_bdt / USD_TO_BDT_RATE_FOR_FEE;
    $stmt_log = $pdo->prepare(
        "INSERT INTO credit_transactions (user_id, payment_transaction_id, cost_bdt, cost_usd, credits_deducted, description)
         VALUES (?, ?, ?, ?, 1, 'API Payment Verification Fee')"
    );
    $stmt_log->execute([$user_id, $transaction_db_id, $fee_bdt, $fee_usd]);
}

// --- Helper Functions ---
function get_client_ip() { $ipaddress = ''; $keys = ['HTTP_CLIENT_IP', 'HTTP_X_FORWARDED_FOR', 'HTTP_X_FORWARDED', 'HTTP_FORWARDED_FOR', 'HTTP_FORWARDED', 'REMOTE_ADDR']; foreach ($keys as $key) { if (isset($_SERVER[$key])) { $ipaddress = $_SERVER[$key]; break; } } return $ipaddress ?: 'UNKNOWN'; }
function generateRandomString($length = 40) { $chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'; $rand = ''; for ($i = 0; $i < $length; $i++) { $rand .= $chars[rand(0, strlen($chars) - 1)]; } return $rand; }

function encryptDataWithPublicKey($data, $publicKey) {
    openssl_public_encrypt($data, $crypttext, $publicKey);
    return base64_encode($crypttext);
}
function generateSignature($data, $privateKey) {
    openssl_sign($data, $signature, $privateKey, OPENSSL_ALGO_SHA256);
    return base64_encode($signature);
}

$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);
$action = $data['action'] ?? null;

// অ্যাকশন অনুযায়ী রুট নির্ধারণ
if ($action === 'initiate_tokenized_payment') {
    try {
        $unique_payment_id = trim($data['unique_payment_id'] ?? '');
        $stmt_session = $pdo->prepare("SELECT user_id, amount FROM transactions WHERE unique_id = ?");
        $stmt_session->execute([$unique_payment_id]);
        $session = $stmt_session->fetch(PDO::FETCH_ASSOC);
        if (!$session) throw new Exception('Payment session not found.');
        
        $stmt_gateway = $pdo->prepare("SELECT * FROM gateways WHERE user_id = ? AND gateway_key = 'bkash_merchant_tokenized'");
        $stmt_gateway->execute([$session['user_id']]);
        $creds = $stmt_gateway->fetch(PDO::FETCH_ASSOC);
        if (!$creds || empty($creds['app_key'])) throw new Exception('bKash Marchant credentials are not configured.');

        $env = $creds['test_mode'] ? 'sandbox' : 'pay';

        $token_url = "https://tokenized.{$env}.bka.sh/v1.2.0-beta/tokenized/checkout/token/grant";
        $token_req_body = json_encode(['app_key' => $creds['app_key'], 'app_secret' => $creds['app_secret']]);
        
        // ★★★ সমাধান: bKash টোকেন অনুরোধে 'x-app-key' হেডার যুক্ত করা হয়েছে ★★★
        $token_headers = [
            'Content-Type: application/json',
            'username: ' . $creds['username'],
            'password: ' . $creds['password'],
            'x-app-key: ' . $creds['app_key'] 
        ];
        
        $ch_token = curl_init();
        curl_setopt_array($ch_token, [CURLOPT_URL => $token_url, CURLOPT_HTTPHEADER => $token_headers, CURLOPT_POSTFIELDS => $token_req_body, CURLOPT_RETURNTRANSFER => true, CURLOPT_POST => 1]);
        $token_res = curl_exec($ch_token);
        $token_data = json_decode($token_res, true);
        curl_close($ch_token);
        
        if (!isset($token_data['id_token'])) {
            throw new Exception($token_data['errorMessage'] ?? 'Failed to get bKash token. Check credentials and environment.');
        }

        $create_url = "https://tokenized.{$env}.bka.sh/v1.2.0-beta/tokenized/checkout/create";
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https" : "http";
        $host = $_SERVER['HTTP_HOST'];
        $directory = rtrim(dirname(dirname($_SERVER['PHP_SELF'])), '/\\');
        $callback_url = "{$protocol}://{$host}{$directory}/checkout.php?trx_id={$unique_payment_id}&bkash_callback=1";
        $create_req_body = json_encode(['mode' => '0011', 'amount' => number_format($session['amount'], 2, '.', ''), 'currency' => 'BDT', 'intent' => 'sale', 'merchantInvoiceNumber' => $unique_payment_id, 'payerReference' => 'user_' . $session['user_id'], 'callbackURL' => $callback_url]);
        $create_headers = ['Content-Type: application/json', 'Authorization: Bearer ' . $token_data['id_token'], 'X-App-Key: ' . $creds['app_key']];
        $ch_create = curl_init();
        curl_setopt_array($ch_create, [CURLOPT_URL => $create_url, CURLOPT_HTTPHEADER => $create_headers, CURLOPT_POSTFIELDS => $create_req_body, CURLOPT_RETURNTRANSFER => true, CURLOPT_POST => 1]);
        $create_res = curl_exec($ch_create);
        $create_data = json_decode($create_res, true);
        curl_close($ch_create);

        if (isset($create_data['bkashURL'])) {
            echo json_encode(['success' => true, 'redirect_url' => $create_data['bkashURL']]);
        } else {
            throw new Exception($create_data['errorMessage'] ?? 'Failed to create bKash payment.');
        }
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => $e->getMessage()]);
    }
    exit();

} elseif ($action === 'initiate_nagad_payment') {
    try {
        $unique_payment_id=trim($data['unique_payment_id']??'');$stmt_session=$pdo->prepare("SELECT user_id, amount FROM transactions WHERE unique_id = ?");$stmt_session->execute([$unique_payment_id]);$session=$stmt_session->fetch(PDO::FETCH_ASSOC);if(!$session)throw new Exception('Payment session not found.');$stmt_gateway=$pdo->prepare("SELECT * FROM gateways WHERE user_id = ? AND gateway_key = 'nagad_merchant'");$stmt_gateway->execute([$session['user_id']]);$creds=$stmt_gateway->fetch(PDO::FETCH_ASSOC);if(!$creds || empty($creds['merchant_id']) || empty($creds['merchant_private_key']) || empty($creds['nagad_public_key'])) throw new Exception('Nagad credentials are not configured. Please check your settings.');
        $nagad_url_prefix = $creds['test_mode'] ? 'https://sandbox-ssl.mynagad.com' : 'https://ssl.mynagad.com';
        $datetime=(new DateTime('now',new DateTimeZone('Asia/Dhaka')))->format('YmdHis');$order_id_nagad=$unique_payment_id.rand(1001,9999);$challenge=generateRandomString();$nagad_headers=['Content-Type: application/json','X-KM-Api-Version: v-0.2.0','X-KM-IP-V4: '.get_client_ip(),'X-KM-Client-Type: PC_WEB'];$sensitive_data=json_encode(['merchantId'=>$creds['merchant_id'],'datetime'=>$datetime,'orderId'=>$order_id_nagad,'challenge'=>$challenge]);$init_data=['dateTime'=>$datetime,'sensitiveData'=>encryptDataWithPublicKey($sensitive_data,$creds['nagad_public_key']),'signature'=>generateSignature($sensitive_data,$creds['merchant_private_key'])];
        $init_url="{$nagad_url_prefix}/api/dfs/check-out/initialize/".$creds['merchant_id']."/".$order_id_nagad;
        $ch_init=curl_init();curl_setopt_array($ch_init,[CURLOPT_URL=>$init_url,CURLOPT_POSTFIELDS=>json_encode($init_data),CURLOPT_HTTPHEADER=>$nagad_headers,CURLOPT_RETURNTRANSFER=>true,CURLOPT_POST=>1]);$init_res=curl_exec($ch_init);curl_close($ch_init);$init_res_data=json_decode($init_res,true);if(!isset($init_res_data['sensitiveData']))throw new Exception($init_res_data['message']??'Nagad initialization failed. Please check your credentials and try again.');
        
        openssl_private_decrypt(base64_decode($init_res_data['sensitiveData']), $decrypted_data, $creds['merchant_private_key']);
        
        $decrypted_data=json_decode($decrypted_data,true);if(!isset($decrypted_data['paymentReferenceId']))throw new Exception('Failed to get payment reference ID from Nagad.');$protocol=(!empty($_SERVER['HTTPS'])&&$_SERVER['HTTPS']!=='off')?"https":"http";$host=$_SERVER['HTTP_HOST'];$directory=rtrim(dirname(dirname($_SERVER['PHP_SELF'])),'/\\');$callback_url="{$protocol}://{$host}{$directory}/checkout.php?nagad_callback=1";$order_sensitive_data=json_encode(['merchantId'=>$creds['merchant_id'],'orderId'=>$order_id_nagad,'currencyCode'=>'050','amount'=>number_format($session['amount'],2,'.',''),'challenge'=>$decrypted_data['challenge']]);$order_post_data=['sensitiveData'=>encryptDataWithPublicKey($order_sensitive_data,$creds['nagad_public_key']),'signature'=>generateSignature($order_sensitive_data,$creds['merchant_private_key']),'merchantCallbackURL'=>$callback_url,'additionalMerchantInfo'=>['order_no'=>$unique_payment_id]];
        $complete_url="{$nagad_url_prefix}/api/dfs/check-out/complete/".$decrypted_data['paymentReferenceId'];
        $ch_complete=curl_init();curl_setopt_array($ch_complete,[CURLOPT_URL=>$complete_url,CURLOPT_POSTFIELDS=>json_encode($order_post_data),CURLOPT_HTTPHEADER=>$nagad_headers,CURLOPT_RETURNTRANSFER=>true,CURLOPT_POST=>1]);$complete_res=curl_exec($ch_complete);curl_close($ch_complete);$complete_res_data=json_decode($complete_res,true);if(isset($complete_res_data['status'])&&$complete_res_data['status']=='Success'){echo json_encode(['success'=>true,'redirect_url'=>$complete_res_data['callBackUrl']]);}else{throw new Exception($complete_res_data['message']??'Failed to complete Nagad checkout.');}
    } catch(Exception $e){http_response_code(500);echo json_encode(['success'=>false,'message'=>$e->getMessage()]);}
    exit();

} 
elseif ($action === 'initiate_checkout_payment') {
    try {
        $unique_payment_id = trim($data['unique_payment_id'] ?? '');
        $stmt_session = $pdo->prepare("SELECT user_id, amount FROM transactions WHERE unique_id = ?");
        $stmt_session->execute([$unique_payment_id]);
        $session = $stmt_session->fetch(PDO::FETCH_ASSOC);
        if (!$session) throw new Exception('Payment session not found.');

        $stmt_gateway = $pdo->prepare("SELECT * FROM gateways WHERE user_id = ? AND gateway_key = 'bkash_merchant_checkout'");
        $stmt_gateway->execute([$session['user_id']]);
        $creds = $stmt_gateway->fetch(PDO::FETCH_ASSOC);
        if (!$creds || empty($creds['app_key'])) throw new Exception('bKash Checkout credentials are not configured.');

        $env = $creds['test_mode'] ? 'sandbox' : 'pay';
        
        $token_url = "https://checkout.{$env}.bka.sh/v1.2.0-beta/checkout/token/grant";
        $token_req_body = json_encode(['app_key' => $creds['app_key'], 'app_secret' => $creds['app_secret']]);
        
        // ★★★ সমাধান: bKash টোকেন অনুরোধে 'x-app-key' হেডার যুক্ত করা হয়েছে ★★★
        $token_headers = [
            'Content-Type: application/json',
            'username: ' . $creds['username'],
            'password: ' . $creds['password'],
            'x-app-key: ' . $creds['app_key']
        ];
        
        $ch_token = curl_init(); curl_setopt_array($ch_token, [CURLOPT_URL => $token_url, CURLOPT_HTTPHEADER => $token_headers, CURLOPT_POSTFIELDS => $token_req_body, CURLOPT_RETURNTRANSFER => true, CURLOPT_POST => 1]);
        $token_res = curl_exec($ch_token); $token_data = json_decode($token_res, true); curl_close($ch_token);
        
        if (!isset($token_data['id_token'])) {
            throw new Exception($token_data['errorMessage'] ?? 'Failed to get bKash token. Check your credentials.');
        }
        
        $create_url = "https://checkout.{$env}.bka.sh/v1.2.0-beta/checkout/payment/create";
        $create_req_body = json_encode(['mode' => '0011', 'amount' => number_format($session['amount'], 2, '.', ''), 'currency' => 'BDT', 'intent' => 'sale', 'merchantInvoiceNumber' => $unique_payment_id]);
        $create_headers = ['Content-Type: application/json', 'Authorization: Bearer ' . $token_data['id_token'], 'X-App-Key: ' . $creds['app_key']];
        $ch_create = curl_init(); curl_setopt_array($ch_create, [CURLOPT_URL => $create_url, CURLOPT_HTTPHEADER => $create_headers, CURLOPT_POSTFIELDS => $create_req_body, CURLOPT_RETURNTRANSFER => true, CURLOPT_POST => 1]);
        $create_res = curl_exec($ch_create); $create_data = json_decode($create_res, true); curl_close($ch_create);

        if (isset($create_data['paymentID'])) {
            echo json_encode(['success' => true, 'bkash_response' => $create_data]);
        } else { throw new Exception($create_data['errorMessage'] ?? 'Failed to create bKash payment.'); }
    } catch (Exception $e) { http_response_code(500); echo json_encode(['success' => false, 'message' => $e->getMessage()]); }
    exit();
}
elseif ($action === 'execute_checkout_payment') {
    try {
        $paymentID = trim($data['paymentID'] ?? '');
        $unique_payment_id = trim($data['unique_payment_id'] ?? '');
        $stmt_trans = $pdo->prepare("SELECT * FROM transactions WHERE unique_id = ?");
        $stmt_trans->execute([$unique_payment_id]);
        $transaction = $stmt_trans->fetch(PDO::FETCH_ASSOC);
        if (!$transaction) throw new Exception('Transaction session not found.');
        
        $stmt_gateway = $pdo->prepare("SELECT * FROM gateways WHERE user_id = ? AND gateway_key = 'bkash_merchant_checkout'");
        $stmt_gateway->execute([$transaction['user_id']]);
        $creds = $stmt_gateway->fetch(PDO::FETCH_ASSOC);
        if (!$creds) throw new Exception('Gateway credentials not found.');

        $env = $creds['test_mode'] ? 'sandbox' : 'pay';
        
        $token_url = "https://checkout.{$env}.bka.sh/v1.2.0-beta/checkout/token/grant";
        $token_req_body = json_encode(['app_key' => $creds['app_key'], 'app_secret' => $creds['app_secret']]);
        $token_headers = [
            'Content-Type: application/json',
            'username: ' . $creds['username'],
            'password: ' . $creds['password'],
            'x-app-key: ' . $creds['app_key']
        ];
        $ch_token = curl_init(); curl_setopt_array($ch_token, [CURLOPT_URL => $token_url, CURLOPT_HTTPHEADER => $token_headers, CURLOPT_POSTFIELDS => $token_req_body, CURLOPT_RETURNTRANSFER => true, CURLOPT_POST => 1]);
        $token_res = curl_exec($ch_token); $token_data = json_decode($token_res, true); curl_close($ch_token);
        if (!isset($token_data['id_token'])) throw new Exception('Failed to get bKash token for execution.');
        
        $execute_url = "https://checkout.{$env}.bka.sh/v1.2.0-beta/checkout/payment/execute/" . $paymentID;
        $execute_headers = ['Content-Type: application/json', 'Authorization: Bearer ' . $token_data['id_token'], 'X-App-Key: ' . $creds['app_key']];
        $ch_exec = curl_init(); curl_setopt_array($ch_exec, [CURLOPT_URL => $execute_url, CURLOPT_HTTPHEADER => $execute_headers, CURLOPT_RETURNTRANSFER => true, CURLOPT_POST => 1]);
        $execute_res = curl_exec($ch_exec); $execute_data = json_decode($execute_res, true); curl_close($ch_exec);
        
        if (isset($execute_data['transactionStatus']) && $execute_data['transactionStatus'] === 'Completed') {
            $pdo->beginTransaction();
            $meta_data = json_decode($transaction['meta_data'], true);
            $source = $meta_data['source'] ?? 'api';
            if ($source !== 'user_funding') {
                deduct_fee_and_log($pdo, $transaction['user_id'], $transaction['id']);
            }
            $pdo->prepare("UPDATE transactions SET status = 'completed', user_submitted_trxid = ? WHERE unique_id = ?")->execute([$execute_data['trxID'], $unique_payment_id]);
            $pdo->commit();

            echo json_encode([
                'success' => true, 
                'message' => 'Payment completed successfully!', 
                'redirect_url' => $transaction['success_url'], 
                'transaction_id' => $execute_data['trxID'],
                'source' => $source
            ]);
        } else { 
            throw new Exception($execute_data['errorMessage'] ?? 'Payment execution failed.'); 
        }
    } catch(Exception $e) { 
        if ($pdo->inTransaction()) $pdo->rollBack();
        http_response_code(500); 
        echo json_encode(['success' => false, 'message' => $e->getMessage()]); 
    }
    exit();
}
else {
    // SMS ভেরিফিকেশন লজিক (ডিফল্ট)
    $user_submitted_trxid = trim($data['transaction_id'] ?? '');
    $unique_payment_id = trim($data['unique_payment_id'] ?? '');
    $gateway_key = trim($data['gateway_key'] ?? '');
    if (empty($user_submitted_trxid) || empty($unique_payment_id) || empty($gateway_key)) { http_response_code(400); echo json_encode(['success' => false, 'message' => 'Required fields are missing.']); exit(); }
    
    try {
        $stmt_session = $pdo->prepare("SELECT * FROM transactions WHERE unique_id = ? AND status = 'pending'");
        $stmt_session->execute([$unique_payment_id]);
        $session = $stmt_session->fetch(PDO::FETCH_ASSOC);
        if (!$session) { http_response_code(404); echo json_encode(['success' => false, 'message' => 'Payment session is invalid or has already been completed.']); exit(); }

        $user_id = $session['user_id']; $required_amount = $session['amount'];
        
        $sender_identifier = '';
        switch ($gateway_key) {
            case 'bkash_personal': $sender_identifier = 'bKash'; break;
            case 'nagad_personal': $sender_identifier = 'Nagad'; break;
            case 'rocket_personal': $sender_identifier = 'Rocket'; break;
            case 'upay_personal': $sender_identifier = 'Upay'; break;
            default: echo json_encode(['success' => false, 'message' => 'Invalid payment gateway specified.']); exit();
        }

        $stmt_sms = $pdo->prepare("SELECT id, amount FROM sms_transactions WHERE user_id = ? AND transaction_id = ? AND status = 'Received' AND sender_number = ? AND is_trashed = 0 LIMIT 1");
        $stmt_sms->execute([$user_id, $user_submitted_trxid, $sender_identifier]);
        $sms = $stmt_sms->fetch(PDO::FETCH_ASSOC);
        if (!$sms || (float)$sms['amount'] != (float)$required_amount) { echo json_encode(['success' => false, 'message' => 'Transaction ID is invalid, already used, or amount mismatch.']); exit(); }

        $pdo->beginTransaction();
        $meta_data = json_decode($session['meta_data'], true);
        $source = $meta_data['source'] ?? 'api';
        if ($source !== 'user_funding') {
            deduct_fee_and_log($pdo, $user_id, $session['id']);
        }
        $pdo->prepare("UPDATE sms_transactions SET status = 'Verified' WHERE id = ?")->execute([$sms['id']]);
        $pdo->prepare("UPDATE transactions SET status = 'completed', user_submitted_trxid = ? WHERE unique_id = ?")->execute([$user_submitted_trxid, $unique_payment_id]);
        $pdo->commit();
        
        echo json_encode([
            'success' => true, 
            'message' => 'Payment verified successfully!', 
            'redirect_url' => $session['success_url'],
            'transaction_id' => $user_submitted_trxid,
            'source' => $source
        ]);

    } catch (Exception $e) {
        if ($pdo->inTransaction()) $pdo->rollBack();
        http_response_code(500);
        if (strpos($e->getMessage(), 'Insufficient credits') !== false) {
            echo json_encode(['success' => false, 'message' => $e->getMessage()]);
        } else {
            echo json_encode(['success' => false, 'message' => 'An error occurred during verification.']);
        }
    }
    exit();
}
?>