<?php
// === requirement_check.php (এই ফাইলের মধ্যেই অন্তর্ভুক্ত) ===
$requirements = [];

// ১. পিএইচপি সংস্করণ পরীক্ষা
$requirements['php_version'] = [
    'name' => 'PHP Version >= 7.4 is available.',
    'status' => version_compare(phpversion(), '7.4.0', '>='),
];

// ২. প্রয়োজনীয় পিএইচপি এক্সটেনশনগুলো পরীক্ষা
$extensions_to_check = [
    'curl' => 'cURL PHP extension is available.',
    'pdo_mysql' => 'PDO MySQL PHP extension is available.',
    'mysqli' => 'Mysqli PHP extension is available.',
    'openssl' => 'OpenSSL PHP extension is available.',
    'fileinfo' => 'Fileinfo PHP extension is available.',
    'bcmath' => 'BCMath PHP extension is available.',
    'json' => 'JSON PHP extension is available.',
    'mbstring' => 'Mbstring PHP extension is available.',
    'zip' => 'Zip PHP extension is available.',
];

foreach ($extensions_to_check as $ext => $name) {
    $requirements[$ext] = [
        'name' => $name,
        'status' => extension_loaded($ext),
    ];
}

// সবগুলো রিকোয়ারমেন্ট পূরণ হয়েছে কিনা তা পরীক্ষা করার জন্য একটি ফ্ল্যাগ
$all_requirements_met = true;
foreach ($requirements as $req) {
    if (!$req['status']) {
        $all_requirements_met = false;
        break;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Welcome - Setup Wizard</title>
    <!-- ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★ -->
    <!-- ★★★            মূল সমাধান এখানে             ★★★ -->
    <!-- ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★ -->
    <!-- filemtime() ফাংশন ব্যবহার করে ক্যাশ বাস্টিং করা হয়েছে -->
    <link rel="stylesheet" href="style.css?v=<?php echo filemtime('style.css'); ?>">
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>
    <div class="container">
        <h1>Welcome to the Setup Wizard</h1>
        <p>This wizard will check your server environment before starting the installation.</p>
        
        <div class="content">
            <h3 class="content-title">Server Requirements</h3>
            <div class="requirements-wrapper">
                <?php foreach ($requirements as $key => $req): ?>
                    <div class="requirement-box <?php echo $req['status'] ? 'success' : 'error'; ?>">
                        <?php if ($req['status']): ?>
                            <i class="fas fa-check icon"></i>
                        <?php else: ?>
                            <i class="fas fa-times icon"></i>
                        <?php endif; ?>
                        <span class="text"><?php echo htmlspecialchars($req['name']); ?></span>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <br>
        
        <form action="index.php" method="GET">
             <input type="hidden" name="step" value="license">
             <button type="submit" class="button" <?php echo !$all_requirements_met ? 'disabled' : ''; ?>>
                <?php if ($all_requirements_met): ?>
                    <i class="fas fa-arrow-right"></i> Start Setup
                <?php else: ?>
                    <i class="fas fa-exclamation-triangle"></i> Requirements Not Met
                <?php endif; ?>
             </button>
        </form>
    </div>
</body>
</html>