<?php
// JSON রেসপন্স পাঠানোর জন্য হেডার সেট করা
header('Content-Type: application/json');

// ডেটাবেস কানেকশন ফাইল যুক্ত করা
require '../db_connect.php';

// --- নিরাপত্তা ব্যবস্থা: মাস্টার এপিআই কী ---
// এই কী'টি অবশ্যই অত্যন্ত সুরক্ষিত এবং গোপন রাখবেন।
define('MASTER_API_KEY', 'Secur1tyKey-For-WHMCS-M0dule-@2025!'); // ★★★ এখানে আপনার নিজের মতো একটি শক্তিশালী কী দিন

// WHMCS মডিউল থেকে পাঠানো এপিআই কী চেক করা হচ্ছে
$provided_key = $_SERVER['HTTP_X_API_KEY'] ?? '';

if (empty($provided_key) || $provided_key !== MASTER_API_KEY) {
    http_response_code(403); // Forbidden
    echo json_encode(['success' => false, 'message' => 'Invalid or missing Master API Key.']);
    exit();
}

// --- WHMCS থেকে পাঠানো ডেটা গ্রহণ করা ---
$username = $_POST['username'] ?? '';
$email = $_POST['email'] ?? '';
$password = $_POST['password'] ?? '';

// --- ডেটা ভ্যালিডেশন ---
if (empty($username) || empty($email) || empty($password)) {
    http_response_code(400); // Bad Request
    echo json_encode(['success' => false, 'message' => 'Username, email, and password are required.']);
    exit();
}

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Invalid email format.']);
    exit();
}

try {
    // --- ইউজার আগে থেকেই আছে কিনা তা পরীক্ষা করা ---
    $stmt_check = $pdo->prepare("SELECT id FROM users WHERE email = ?");
    $stmt_check->execute([$email]);
    if ($stmt_check->fetch()) {
        http_response_code(409); // Conflict
        echo json_encode(['success' => false, 'message' => 'A user with this email already exists.']);
        exit();
    }

    // --- নতুন ইউজার তৈরি করা ---
    $pdo->beginTransaction();

    // ১. পাসওয়ার্ড হ্যাশ করা
    $hashed_password = password_hash($password, PASSWORD_DEFAULT);

    // ২. `users` টেবিলে নতুন ইউজার যুক্ত করা
    $sql_user = "INSERT INTO users (username, email, password) VALUES (?, ?, ?)";
    $stmt_user = $pdo->prepare($sql_user);
    $stmt_user->execute([$username, $email, $hashed_password]);

    // ৩. নতুন তৈরি হওয়া ইউজারের আইডি (user_id) নেওয়া
    $user_id = $pdo->lastInsertId();

    // ৪. এই নতুন ইউজারের জন্য একটি স্বতন্ত্র API Key তৈরি করা
    $new_api_key = bin2hex(random_bytes(32));

    // ৫. `settings` টেবিলে এই user_id এবং new_api_key সেভ করা
    $sql_settings = "INSERT INTO settings (user_id, api_key) VALUES (?, ?)";
    $stmt_settings = $pdo->prepare($sql_settings);
    $stmt_settings->execute([$user_id, $new_api_key]);

    $pdo->commit();

    // সফলভাবে তৈরি হওয়ার পর বার্তা পাঠানো
    echo json_encode([
        'success' => true, 
        'message' => 'User created successfully in the dashboard project.',
        'user_id' => $user_id,
        'username' => $username
    ]);

} catch (PDOException $e) {
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }
    http_response_code(500); // Internal Server Error
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
?>