<?php
header('Content-Type: application/json');
require '../db_connect.php';

// API Key দিয়ে অথেন্টিকেশন
$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';
if (empty($api_key)) { http_response_code(401); die(json_encode(['success' => false, 'message' => 'API Key is missing.'])); }

$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting = $stmt_user->fetch(PDO::FETCH_ASSOC);
if (!$setting) { http_response_code(403); die(json_encode(['success' => false, 'message' => 'Invalid API Key.'])); }

$user_id = $setting['user_id'];

try {
    // Fetch current balance from users table
    $stmt_balance = $pdo->prepare("SELECT balance FROM users WHERE id = ?");
    $stmt_balance->execute([$user_id]);
    $user = $stmt_balance->fetch(PDO::FETCH_ASSOC);
    $current_balance = $user['balance'] ?? 0.00;

    // Calculate purchased credits
    $stmt_purchased = $pdo->prepare("SELECT COALESCE(SUM(amount_bdt), 0) as total_purchased FROM user_funds WHERE user_id = ? AND status = 'completed' AND transaction_unique_id LIKE 'manual_purchase_%'");
    $stmt_purchased->execute([$user_id]);
    $purchased_credits = $stmt_purchased->fetchColumn() ?? 0;

    $free_credits = 50;
    $total_credits = $free_credits + $purchased_credits;

    // Calculate used credits
    $stmt_used = $pdo->prepare("SELECT COUNT(id) as total_used FROM credit_transactions WHERE user_id = ?");
    $stmt_used->execute([$user_id]);
    $used_credits = $stmt_used->fetchColumn() ?? 0;
    
    $remaining_credits = $total_credits - $used_credits;
    $usage_percentage = ($total_credits > 0) ? ($used_credits / $total_credits) * 100 : 0;

    echo json_encode([
        'success' => true,
        'balance_usd' => (float)$current_balance,
        'used_credits' => (int)$used_credits,
        'total_credits' => (int)$total_credits,
        'remaining_credits' => (int)$remaining_credits,
        'usage_percentage' => (float)$usage_percentage
    ]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error.']);
}
?>