<?php
header('Content-Type: application/json');
require '../db_connect.php';

// API Key Authentication
$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';
if (empty($api_key)) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'API Key is missing.']);
    exit();
}
$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting = $stmt_user->fetch(PDO::FETCH_ASSOC);
if (!$setting) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Invalid API Key.']);
    exit();
}
$user_id = $setting['user_id'];

try {
    // Total Payments (Completed)
    $stmt_total = $pdo->prepare("SELECT COUNT(id) FROM transactions WHERE user_id = ? AND status = 'completed'");
    $stmt_total->execute([$user_id]);
    $total_payments = $stmt_total->fetchColumn();

    // Pending Payments
    $stmt_pending = $pdo->prepare("SELECT COUNT(id) FROM transactions WHERE user_id = ? AND status = 'pending'");
    $stmt_pending->execute([$user_id]);
    $pending_payments = $stmt_pending->fetchColumn();

    // Total Customers (unique emails)
    $stmt_customers = $pdo->prepare("SELECT COUNT(DISTINCT customer_email) FROM transactions WHERE user_id = ? AND customer_email IS NOT NULL AND customer_email != ''");
    $stmt_customers->execute([$user_id]);
    $total_customers = $stmt_customers->fetchColumn();

    // Unpaid Invoices (using pending payments count as a placeholder)
    $unpaid_invoices = $pending_payments; 

    // Send response
    echo json_encode([
        'success' => true,
        'total_payment' => $total_payments,
        'pending_payment' => $pending_payments,
        'unpaid_invoice' => $unpaid_invoices,
        'total_customer' => $total_customers
    ]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
?>